/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.test;

import java.util.ArrayList;
import java.util.Date;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.assay.Batch;
import org.labkey.remoteapi.assay.Data;
import org.labkey.remoteapi.assay.Run;
import org.labkey.remoteapi.assay.SaveAssayBatchCommand;

public class SaveAssayBatchDemo {
    public static void main(String ... args) throws Exception {
        block9: {
            String folderPath;
            int assayId;
            if (args.length != 5 && args.length != 7) {
                System.err.println("Invalid arguments");
                if (args.length == 6) {
                    System.err.println("If you specify a username, you must also specify a password");
                }
                SaveAssayBatchDemo.printUsage();
                System.exit(1);
            }
            String fileName = args[0];
            String description = args[1].trim();
            if (description.length() == 0) {
                System.err.println("Invalid usage description");
                SaveAssayBatchDemo.printUsage();
                System.exit(1);
            }
            try {
                assayId = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.err.println("Could not parse assayId " + args[2]);
                SaveAssayBatchDemo.printUsage();
                System.exit(1);
                return;
            }
            String baseServerURL = args[3];
            if (!baseServerURL.toLowerCase().startsWith("http")) {
                System.err.println("Invalid base server URL, expected it to start with http or https " + args[3]);
                SaveAssayBatchDemo.printUsage();
                System.exit(1);
            }
            if (!(folderPath = args[4]).startsWith("/")) {
                folderPath = "/" + folderPath;
            }
            Batch batch = new Batch();
            batch.setName("Batch " + description);
            Run run = new Run();
            run.setName(description);
            run.getProperties().put("MyDate", new Date());
            batch.getRuns().add(run);
            ArrayList<Data> inputFiles = new ArrayList<Data>();
            Data data = new Data();
            data.setAbsolutePath(fileName);
            System.out.println("Adding usage \"" + description + " \" for file \"" + fileName + "\"");
            inputFiles.add(data);
            run.setDataInputs(inputFiles);
            SaveAssayBatchCommand command = new SaveAssayBatchCommand(assayId, batch);
            Connection connection = args.length == 7 ? new Connection(baseServerURL, args[5], args[6]) : new Connection(baseServerURL);
            try {
                command.execute(connection, folderPath);
                System.out.println("Success!");
            }
            catch (CommandException e) {
                System.err.println("Failure! Response code: " + e.getStatusCode());
                e.printStackTrace();
                System.err.println();
                if (e.getResponseText() == null) break block9;
                System.err.println("Response text: ");
                System.err.println(e.getResponseText());
            }
        }
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Expected usage: java " + SaveAssayBatchDemo.class.getName() + " [FILE_NAME] [DESCRIPTION] [ASSAY_ID] [BASE_SERVER_URL] [TARGET_FOLDER] <USERNAME> <PASSWORD>");
        System.err.println("\t[FILE_NAME]:       relative path to the file to be marked by this usage; the web server must see the file at the same path");
        System.err.println("\t[DESCRIPTION]:     string to be used as the name of this usage");
        System.err.println("\t[ASSAY_ID]:        the assay ID (RowID) of the assay definition to be used for this usage");
        System.err.println("\t[BASE_SERVER_URL]: URL of the LabKey Server instance in which to store the usage, for example: https://www.myserver.com/labkey");
        System.err.println("\t[TARGET_FOLDER]:   target project and folder where the usage should be stored, for example: /MyProject/MyFolder");
        System.err.println("\t<USERNAME>:        (optional) username with which to authenticate");
        System.err.println("\t<PASSWORD>:        (optional) password with which to authenticate");
    }
}

