/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.test;

import java.util.Map;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.query.ExecuteSqlCommand;
import org.labkey.remoteapi.query.Filter;
import org.labkey.remoteapi.query.SelectRowsCommand;
import org.labkey.remoteapi.query.SelectRowsResponse;
import org.labkey.remoteapi.query.Sort;

public class Demo {
    private String _email = null;
    private String _password = null;
    private Connection _connection = null;

    public void doDemo() throws Exception {
        this.simpleSelectDemo();
        this.sortFilterDemo();
        this.executeSqlDemo();
        this.getWebPartDemo();
    }

    public void simpleSelectDemo() throws Exception {
        System.out.println("-----------------------------------------------");
        System.out.println("Simple Select Demo");
        System.out.println("-----------------------------------------------");
        Connection cn = new Connection("http://localhost:8080/labkey", this._email, this._password);
        SelectRowsCommand cmd = new SelectRowsCommand("lists", "People");
        SelectRowsResponse resp = (SelectRowsResponse)cmd.execute(cn, "Api Test");
        System.out.println(resp.getRowCount() + " rows were returned.");
        for (Map row : resp.getRows()) {
            System.out.println(row.get("FirstName") + " is " + row.get("Age"));
        }
    }

    public void sortFilterDemo() throws Exception {
        System.out.println("-----------------------------------------------");
        System.out.println("Sort/Filter Demo");
        System.out.println("-----------------------------------------------");
        Connection cn = this.getConnection();
        SelectRowsCommand cmd = new SelectRowsCommand("lists", "People");
        cmd.addSort("Age", Sort.Direction.DESCENDING);
        cmd.addFilter("Age", 30, Filter.Operator.GTE);
        cmd.addFilter("Age", 50, Filter.Operator.LTE);
        SelectRowsResponse resp = (SelectRowsResponse)cmd.execute(cn, "Api Test");
        for (Map row : resp.getRows()) {
            System.out.println(row.get("FirstName") + " is " + row.get("Age"));
        }
    }

    public void executeSqlDemo() throws Exception {
        System.out.println("-----------------------------------------------");
        System.out.println("Execute SQL Demo");
        System.out.println("-----------------------------------------------");
        Connection cn = this.getConnection();
        ExecuteSqlCommand cmd = new ExecuteSqlCommand("lists");
        cmd.setSql("select avg(People.Age) as AvgAge from People");
        cmd.setTimeout(0);
        SelectRowsResponse resp = (SelectRowsResponse)cmd.execute(cn, "Api Test");
        System.out.println("Average Age is " + ((Map)resp.getRows().get(0)).get("AvgAge"));
    }

    public void getWebPartDemo() throws Exception {
        System.out.println("-----------------------------------------------");
        System.out.println("Get Web Part Demo");
        System.out.println("-----------------------------------------------");
        Connection cn = this.getConnection();
        Command cmd = new Command("project", "getWebPart");
        cmd.getParameters().put("webpart.name", "Wiki");
        cmd.getParameters().put("name", "home");
        Object resp = cmd.execute(cn, "Api Test");
        System.out.println(((CommandResponse)resp).getText());
    }

    public static void main(String[] args) throws Exception {
        Demo d = new Demo(args);
        d.doDemo();
    }

    public Demo(String[] args) throws Exception {
        this.processArgs(args);
        if (null == this._email || null == this._password) {
            throw new Exception("Usage: java demo.class <user> <password>");
        }
    }

    private void processArgs(String[] args) {
        if (args.length >= 2) {
            this._email = args[0];
            this._password = args[1];
        }
    }

    private Connection getConnection() {
        if (null == this._connection) {
            this._connection = new Connection("http://localhost:8080/labkey", this._email, this._password);
        }
        return this._connection;
    }
}

