/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.query.SelectRowsResponse;
import org.labkey.remoteapi.sas.SASBaseSelectCommand;
import org.labkey.remoteapi.sas.SASConnection;
import org.labkey.remoteapi.sas.SASExecuteSqlCommand;
import org.labkey.remoteapi.sas.SASSelectRowsCommand;

public class SASSelectRowsResponse {
    private final SelectRowsResponse _resp;
    private final Iterator<Map<String, Object>> _rowIterator;
    private Map<String, String> _sasToApiNames;
    private Map<String, String> _apiToSasNames;
    private Map<String, Object> _currentRow;
    private static final Pattern SAS_IDENTIFIER = Pattern.compile("[a-zA-Z_][\\w]{0,31}");
    private static final String LEGAL_FIRST_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
    private static final String LEGAL_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
    private DateFormat _df = new SimpleDateFormat("yyyy-MM-dd");

    public SASSelectRowsResponse(SASConnection cn, SASSelectRowsCommand command, String folderPath) throws CommandException, IOException {
        this(cn, (SASBaseSelectCommand)command, folderPath);
    }

    public SASSelectRowsResponse(SASConnection cn, SASExecuteSqlCommand command, String folderPath) throws CommandException, IOException {
        this(cn, (SASBaseSelectCommand)command, folderPath);
    }

    private SASSelectRowsResponse(SASConnection cn, SASBaseSelectCommand command, String folderPath) throws CommandException, IOException {
        this._resp = command.execute(cn, folderPath);
        this._rowIterator = this._resp.getRows().iterator();
        this.createNameMapping(this.getFields());
    }

    private List<Map<String, String>> getFields() {
        return (List)this._resp.getMetaData().get("fields");
    }

    private void createNameMapping(List<Map<String, String>> fields) {
        this._sasToApiNames = new HashMap<String, String>(fields.size());
        this._apiToSasNames = new HashMap<String, String>(fields.size());
        for (Map<String, String> field : fields) {
            String apiName = field.get("name");
            String sasName = SASSelectRowsResponse.makeLegal(apiName, this._sasToApiNames.keySet());
            this._apiToSasNames.put(apiName, sasName);
            this._sasToApiNames.put(sasName, apiName);
        }
    }

    public static void testMakeLegal() {
        ArrayList<String> testNames = new ArrayList<String>(120);
        testNames.addAll(Arrays.asList("Foo", "Foo", "1Foo", "_Foo", "$56TS", "this/that", "howdeedoo_", "howdeedoo#"));
        for (int i = 0; i < 102; ++i) {
            testNames.add("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghi");
        }
        HashSet<String> identifiers = new HashSet<String>(testNames.size());
        for (String apiName : testNames) {
            String sasName = SASSelectRowsResponse.makeLegal(apiName, identifiers);
            if (!SASSelectRowsResponse.isLegal(sasName)) {
                throw new IllegalStateException(apiName + " translated to " + sasName + ", which is not a legal SAS identifier");
            }
            System.out.println(apiName + " " + sasName);
            identifiers.add(sasName);
        }
        int testCount = 100000;
        identifiers = new HashSet(testCount);
        Random random = new Random();
        for (int i = 0; i < testCount; ++i) {
            StringBuilder sb = new StringBuilder();
            int length = 1 + random.nextInt(40);
            for (int j = 0; j < length; ++j) {
                sb.append((char)(32 + random.nextInt(95)));
            }
            String sasName = SASSelectRowsResponse.makeLegal(sb.toString(), identifiers);
            if (!SASSelectRowsResponse.isLegal(sasName)) {
                throw new IllegalStateException("\"" + sb.toString() + "\" translated to \"" + sasName + "\", which is not a legal SAS identifier");
            }
            if (identifiers.add(sasName)) continue;
            throw new IllegalStateException("\"" + sasName + "\"" + " already exists");
        }
    }

    private static String makeLegal(String apiName, Set<String> currentNames) {
        String legalName = apiName;
        if (!SASSelectRowsResponse.isLegal(apiName)) {
            StringBuilder sasName = new StringBuilder(apiName.substring(0, Math.min(32, apiName.length())));
            String chars = LEGAL_FIRST_CHARS;
            for (int i = 0; i < sasName.length(); ++i) {
                if (-1 == chars.indexOf(sasName.charAt(i))) {
                    sasName.setCharAt(i, '_');
                }
                chars = LEGAL_CHARS;
            }
            legalName = sasName.toString();
        }
        int i = 1;
        String candidateName = legalName;
        while (currentNames.contains(candidateName)) {
            String suffix = String.valueOf(++i);
            if (legalName.length() + suffix.length() > 32) {
                candidateName = legalName.substring(0, 32 - suffix.length()) + suffix;
                continue;
            }
            candidateName = legalName + suffix;
        }
        return candidateName;
    }

    private static boolean isLegal(String identifier) {
        return identifier.length() <= 32 && SAS_IDENTIFIER.matcher(identifier).matches();
    }

    private String getSasName(String apiName) {
        return this._apiToSasNames.get(apiName);
    }

    private String getApiName(String apiName) {
        return this._sasToApiNames.get(apiName.trim());
    }

    public int getColumnCount() {
        return this.getFields().size();
    }

    public String getColumnName(double index) {
        int i = (int)Math.round(index);
        String apiName = this.getFields().get(i).get("name");
        return this.getSasName(apiName);
    }

    public String getType(String sasName) {
        String apiName = this.getApiName(sasName);
        SelectRowsResponse.ColumnDataType type = this._resp.getColumnDataType(apiName);
        return type.toString();
    }

    private Object getColumnModelProperty(double index, String propName) {
        int i = (int)Math.round(index);
        Map<String, Object> columnModel = this._resp.getColumnModel().get(i);
        return columnModel.get(propName);
    }

    public boolean isHidden(double index) {
        return (Boolean)this.getColumnModelProperty(index, "hidden");
    }

    public int getScale(double index) {
        int scale = ((Number)this.getColumnModelProperty(index, "scale")).intValue();
        return 0 == scale ? 100 : scale;
    }

    public String getLabel(double index) {
        return (String)this.getColumnModelProperty(index, "header");
    }

    public boolean allowsMissingValues(String sasName) {
        String apiName = this.getApiName(sasName);
        Boolean mvEnabled = (Boolean)this._resp.getMetaData(apiName).get("mvEnabled");
        return null != mvEnabled && mvEnabled != false;
    }

    public String getMissingValuesCode() {
        Map qcInfo = (Map)this._resp.getParsedData().get("qcInfo");
        StringBuilder values = new StringBuilder();
        StringBuilder footnotes = new StringBuilder();
        if (null != qcInfo) {
            int count = 1;
            for (Map.Entry missing : qcInfo.entrySet()) {
                values.append(" ").append((String)missing.getKey());
                if (count > 10) continue;
                footnotes.append("footnote").append(count++).append(" \"").append((String)missing.getKey()).append(" - ").append((String)missing.getValue()).append("\";\n");
            }
        }
        if (values.length() > 0) {
            return "missing" + values + ";\n" + footnotes;
        }
        return "footnote;";
    }

    public boolean getRow() {
        boolean hasNext = this._rowIterator.hasNext();
        if (hasNext) {
            this._currentRow = this._rowIterator.next();
        }
        return hasNext;
    }

    private Object getValue(String sasName) {
        String apiName = this.getApiName(sasName);
        Object o = this._currentRow.get(apiName);
        if (this._resp.getRequiredVersion() < 9.1) {
            return o;
        }
        return ((JSONObject)o).get((Object)"value");
    }

    public boolean isNull(String sasName) {
        return null == this.getValue(sasName);
    }

    public String getCharacter(String sasName) {
        return (String)this.getValue(sasName);
    }

    public double getNumeric(String sasName) {
        return ((Number)this.getValue(sasName)).doubleValue();
    }

    public boolean getBoolean(String sasName) {
        return (Boolean)this.getValue(sasName);
    }

    public String getDate(String sasName) {
        Date d = (Date)this.getValue(sasName);
        return this._df.format(d);
    }

    public String getMissingValue(String sasName) {
        if (this._resp.getRequiredVersion() < 9.1) {
            throw new IllegalStateException("Missing values are only available when requiring LabKey 9.1 or later version");
        }
        String apiName = this.getApiName(sasName);
        Object o = this._currentRow.get(apiName);
        return (String)((JSONObject)o).get((Object)"mvValue");
    }
}

