/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.labkey.remoteapi.query.jdbc.BaseJDBC;
import org.labkey.remoteapi.query.jdbc.LabKeyConnection;
import org.labkey.remoteapi.query.jdbc.LabKeyResultSet;

public class LabKeyResultSetMetaData
extends BaseJDBC
implements ResultSetMetaData {
    private final List<LabKeyResultSet.Column> _columns;
    private final LabKeyConnection _connection;

    public LabKeyResultSetMetaData(List<LabKeyResultSet.Column> columns, LabKeyConnection connection) {
        this._columns = columns;
        this._connection = connection;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this._connection.getFolderPath();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 10;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "unknown";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 4;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 4;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "unknown";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Class type = this.getColumn(column).getType();
        if (type == String.class) {
            return 12;
        }
        if (type == Integer.class) {
            return 4;
        }
        if (type == Long.class) {
            return -5;
        }
        if (type == Date.class) {
            return 91;
        }
        if (type == Short.class) {
            return 4;
        }
        if (type == Byte.class) {
            return 4;
        }
        if (type == Double.class) {
            return 8;
        }
        if (type == Float.class) {
            return 6;
        }
        if (type == Boolean.class) {
            return 16;
        }
        throw new UnsupportedOperationException("Unexpected type: " + type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        Class type = this.getColumn(column).getType();
        if (type == String.class) {
            return "VARCHAR";
        }
        if (type == Integer.class) {
            return "INTEGER";
        }
        if (type == Long.class) {
            return "BIGINT";
        }
        if (type == Date.class) {
            return "DATE";
        }
        if (type == Short.class) {
            return "INTEGER";
        }
        if (type == Byte.class) {
            return "INTEGER";
        }
        if (type == Double.class) {
            return "DOUBLE";
        }
        if (type == Float.class) {
            return "FLOAT";
        }
        if (type == Boolean.class) {
            return "BOOLEAN";
        }
        throw new UnsupportedOperationException("Unexpected type: " + type);
    }

    private LabKeyResultSet.Column getColumn(int column) {
        return this._columns.get(column - 1);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumn(column).getType().getName();
    }
}

