/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query.jdbc;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.query.jdbc.LabKeyConnection;

public class LabKeyDriver
implements Driver {
    private static final String URL_PREFIX = "jdbc:labkey:";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(URL_PREFIX);
    }

    @Override
    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        Connection connection;
        if (url.startsWith(URL_PREFIX)) {
            url = url.substring(URL_PREFIX.length());
        }
        String user = info.getProperty("user");
        String password = info.getProperty("password");
        if (user != null && password != null) {
            connection = new Connection(url, user, password);
        } else {
            try {
                connection = new Connection(url);
            }
            catch (IOException | URISyntaxException e) {
                throw new SQLException(e);
            }
        }
        LabKeyConnection labKeyConnection = new LabKeyConnection(connection);
        labKeyConnection.setClientInfo(info);
        return labKeyConnection;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            DriverManager.registerDriver(new LabKeyDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

