/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.PostCommand;
import org.labkey.remoteapi.query.SaveRowsResponse;

public abstract class SaveRowsCommand
extends PostCommand<SaveRowsResponse> {
    private String _schemaName;
    private String _queryName;
    private Map<String, Object> _extraContext;
    private List<Map<String, Object>> _rows = new ArrayList<Map<String, Object>>();

    protected SaveRowsCommand(String schemaName, String queryName, String actionName) {
        super("query", actionName);
        assert (null != schemaName);
        assert (null != queryName);
        this._schemaName = schemaName;
        this._queryName = queryName;
    }

    protected SaveRowsCommand(SaveRowsCommand source) {
        super(source);
        this._queryName = source._queryName;
        this._schemaName = source._schemaName;
        this._extraContext = source._extraContext;
        this._rows = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : source._rows) {
            this._rows.add(new HashMap<String, Object>(row));
        }
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public String getQueryName() {
        return this._queryName;
    }

    public void setQueryName(String queryName) {
        this._queryName = queryName;
    }

    public Map<String, Object> getExtraContext() {
        return this._extraContext;
    }

    public void setExtraContext(Map<String, Object> extraContext) {
        this._extraContext = extraContext;
    }

    public List<Map<String, Object>> getRows() {
        return this._rows;
    }

    public void setRows(List<Map<String, Object>> rows) {
        this._rows = rows;
    }

    public void addRow(Map<String, Object> row) {
        this._rows.add(row);
    }

    @Override
    public JSONObject getJsonObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"schemaName", (Object)this.getSchemaName());
        json.put((Object)"queryName", (Object)this.getQueryName());
        if (this.getExtraContext() != null) {
            json.put((Object)"extraContext", this.getExtraContext());
        }
        JSONArray jsonRows = new JSONArray();
        if (null != this.getRows()) {
            SimpleDateFormat fmt = new SimpleDateFormat("d MMM yyyy HH:mm:ss Z");
            for (Map<String, Object> row : this.getRows()) {
                JSONObject jsonRow;
                if (row instanceof JSONObject) {
                    jsonRow = (JSONObject)row;
                } else {
                    jsonRow = new JSONObject();
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        Object value = entry.getValue();
                        if (value instanceof Date) {
                            value = fmt.format((Date)value);
                        }
                        jsonRow.put((Object)entry.getKey(), value);
                    }
                }
                jsonRows.add((Object)jsonRow);
            }
        }
        json.put((Object)"rows", (Object)jsonRows);
        return json;
    }

    @Override
    protected SaveRowsResponse createResponse(String text, int status, String contentType, JSONObject json) {
        return new SaveRowsResponse(text, status, contentType, json, this.copy());
    }

    @Override
    public abstract SaveRowsCommand copy();
}

