/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.util.HashMap;
import java.util.Map;

public class Filter {
    private String _columnName;
    private Operator _operator;
    private Object _value;

    public Filter(String columnName, Object value) {
        this._columnName = columnName;
        this._value = value;
        this._operator = Operator.EQUAL;
    }

    public Filter(String columnName, Object value, Operator operator) {
        this._columnName = columnName;
        this._value = value;
        this._operator = operator;
    }

    public Filter(Filter source) {
        this._columnName = source._columnName;
        this._operator = source._operator;
        this._value = source._value;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public void setColumnName(String columnName) {
        this._columnName = columnName;
    }

    public Operator getOperator() {
        return this._operator;
    }

    public void setOperator(Operator operator) {
        this._operator = operator;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getQueryStringParamName() {
        return null == this.getColumnName() || null == this.getOperator() ? "" : this.getColumnName() + "~" + this.getOperator().getUrlKey();
    }

    public String getQueryStringParamValue() {
        return null == this.getValue() ? "" : this.getValue().toString();
    }

    public String toString() {
        return "Filter: " + this.getColumnName() + " " + this.getOperator().getDisplayValue() + " " + this.getValue();
    }

    public static enum Operator {
        EQUAL("Equals", "eq", "EQUAL", true),
        DATE_EQUAL("Equals", "dateeq", "DATE_EQUAL", true),
        NEQ("Does Not Equal", "neq", "NOT_EQUAL", true),
        DATE_NOT_EQUAL("Does Not Equal", "dateneq", "DATE_NOT_EQUAL", true),
        NEQ_OR_NULL("Does Not Equal", "neqornull", "NOT_EQUAL_OR_MISSING", true),
        GT("Is Greater Than", "gt", "GREATER_THAN", true),
        DATE_GT("(Date) Is Greater Than", "dategt", "DATE_GREATER_THAN", true),
        LT("Is Less Than", "lt", "LESS_THAN", true),
        DATE_LT("(Date) Is Less Than", "datelt", "DATE_LESS_THAN", true),
        GTE("Is Greater Than or Equal To", "gte", "GREATER_THAN_OR_EQUAL", true),
        DATE_GTE("(Date) Is Greater Than or Equal To", "dategte", "DATE_GREATER_THAN_OR_EQUAL", true),
        LTE("Is Less Than or Equal To", "lte", "LESS_THAN_OR_EQUAL", true),
        DATE_LTE("(Date) Is Less Than or Equal To", "datelte", "DATE_LESS_THAN_OR_EQUAL", true),
        STARTS_WITH("Starts With", "startswith", "STARTS_WITH", true),
        DOES_NOT_START_WITH("Does Not Start With", "doesnotstartwith", "DOES_NOT_START_WITH", true),
        CONTAINS("Contains", "contains", "CONTAINS", true),
        DOES_NOT_CONTAIN("Does Not Contain", "doesnotcontain", "DOES_NOT_CONTAIN", true),
        CONTAINS_ONE_OF("Contains One Of (example usage: a;b;c)", "containsoneof", "CONTAINS_ONE_OF", true),
        CONTAINS_NONE_OF("Does Not Contain Any Of (example usage: a;b;c)", "containsnoneof", "CONTAINS_NONE_OF", true),
        IN("Equals One Of", "in", "IN", true),
        NOT_IN("Does Not Equal Any Of (example usage: a;b;c)", "notin", "NOT_IN", true),
        BETWEEN("Between, Inclusive (example usage: -4,4)", "between", "BETWEEN", true),
        NOT_BETWEEN("Not Between, Exclusive (example usage: -4,4)", "notbetween", "NOT_BETWEEN", true),
        MEMBER_OF("Member Of", "memberof", "MEMBER_OF", true),
        ISBLANK("Is Blank", "isblank", "MISSING", false),
        NON_BLANK("Is Not Blank", "isnonblank", "NOT_MISSING", false),
        NONBLANK("Is Not Blank", "isnonblank", "NOT_MISSING", false),
        MV_INDICATOR("Has Missing Value Indicator", "hasmvvalue", "MV_INDICATOR", false),
        NO_MV_INDICATOR("Does Not Have Missing Value Indicator", "nomvvalue", "NO_MV_INDICATOR", false);

        private static final Map<String, Operator> _programmaticNameToOperator;
        private final String _urlKey;
        private final String _displayValue;
        private final String _programmaticName;
        private final boolean _dataValueRequired;

        private Operator(String displayValue, String urlKey, String programmaticName, boolean dataValueRequired) {
            this._displayValue = displayValue;
            this._urlKey = urlKey;
            this._programmaticName = programmaticName;
            this._dataValueRequired = dataValueRequired;
        }

        public String getDisplayValue() {
            return this._displayValue;
        }

        public String getUrlKey() {
            return this._urlKey;
        }

        public boolean isDataValueRequired() {
            return this._dataValueRequired;
        }

        public String getProgrammaticName() {
            return this._programmaticName;
        }

        public static Operator getOperator(String programmaticName) {
            return _programmaticNameToOperator.get(programmaticName);
        }

        @Deprecated
        public String getCaption() {
            return this._displayValue;
        }

        @Deprecated
        public String getName() {
            return this._urlKey;
        }

        @Deprecated
        public boolean isValueRequired() {
            return this._dataValueRequired;
        }

        static {
            _programmaticNameToOperator = new HashMap<String, Operator>(Operator.values().length);
            for (Operator o : Operator.values()) {
                _programmaticNameToOperator.put(o.getProgrammaticName(), o);
            }
        }
    }
}

