/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.PostCommand;
import org.labkey.remoteapi.query.BaseSelect;
import org.labkey.remoteapi.query.ContainerFilter;
import org.labkey.remoteapi.query.SelectRowsResponse;
import org.labkey.remoteapi.query.Sort;

public class ExecuteSqlCommand
extends PostCommand<SelectRowsResponse>
implements BaseSelect {
    private String _schemaName;
    private String _sql;
    private int _maxRows = -1;
    private int _offset = 0;
    private ContainerFilter _containerFilter;
    private boolean _includeTotalCount = true;
    private List<Sort> _sorts;
    private boolean _saveInSession = false;
    private boolean _includeDetailsColumn = false;
    private Map<String, String> _queryParameters = new HashMap<String, String>();

    public ExecuteSqlCommand(String schemaName) {
        super("query", "executeSql");
        this._schemaName = schemaName;
    }

    public ExecuteSqlCommand(ExecuteSqlCommand source) {
        super(source);
        this._schemaName = source._schemaName;
        this._sql = source._sql;
        this._maxRows = source._maxRows;
        this._offset = source._offset;
        this._containerFilter = source._containerFilter;
        this._includeTotalCount = source._includeTotalCount;
        this._sorts = source._sorts;
        this._saveInSession = source._saveInSession;
        this._includeDetailsColumn = source._includeDetailsColumn;
        this._queryParameters = new HashMap<String, String>(source.getQueryParameters());
    }

    public ExecuteSqlCommand(String schemaName, String sql) {
        super("query", "executeSql");
        this._schemaName = schemaName;
        this._sql = sql;
    }

    public void setExtendedFormat(boolean extendedFormat) {
        this.setRequiredVersion(extendedFormat ? 9.1 : 8.3);
    }

    public boolean isExtendedFormat() {
        return this.getRequiredVersion() == 9.1;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public String getSql() {
        return this._sql;
    }

    public void setSql(String sql) {
        this._sql = sql;
    }

    @Override
    public int getMaxRows() {
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    @Override
    public void setOffset(int offset) {
        this._offset = offset;
    }

    public boolean isIncludeTotalCount() {
        return this._includeTotalCount;
    }

    public void setIncludeTotalCount(boolean includeTotalCount) {
        this._includeTotalCount = includeTotalCount;
    }

    public List<Sort> getSorts() {
        return this._sorts;
    }

    public void setSort(List<Sort> sorts) {
        this._sorts = sorts;
    }

    public boolean isSaveInSession() {
        return this._saveInSession;
    }

    public void setSaveInSession(boolean saveInSession) {
        this._saveInSession = saveInSession;
    }

    public boolean isIncludeDetailsColumn() {
        return this._includeDetailsColumn;
    }

    public void setIncludeDetailsColumn(boolean includeDetailsColumn) {
        this._includeDetailsColumn = includeDetailsColumn;
    }

    public Map<String, String> getQueryParameters() {
        return this._queryParameters;
    }

    public void setQueryParameters(Map<String, String> parameters) {
        this._queryParameters = parameters;
    }

    @Override
    public ContainerFilter getContainerFilter() {
        return this._containerFilter;
    }

    @Override
    public void setContainerFilter(ContainerFilter containerFilter) {
        this._containerFilter = containerFilter;
    }

    @Override
    protected SelectRowsResponse createResponse(String text, int status, String contentType, JSONObject json) {
        assert (null != this._schemaName) : "You must set the schemaName before executing!";
        assert (null != this._sql) : "You must set the Sql before executing!";
        return new SelectRowsResponse(text, status, contentType, json, this.copy());
    }

    @Override
    public JSONObject getJsonObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"schemaName", (Object)this.getSchemaName());
        json.put((Object)"sql", (Object)this.getSql());
        if (this.getMaxRows() >= 0) {
            json.put((Object)"maxRows", (Object)this.getMaxRows());
        }
        if (this.getOffset() > 0) {
            json.put((Object)"offset", (Object)this.getOffset());
        }
        if (this.getContainerFilter() != null) {
            json.put((Object)"containerFilter", (Object)this.getContainerFilter().name());
        }
        json.put((Object)"includeTotalCount", (Object)this.isIncludeTotalCount());
        json.put((Object)"includeDetailsColumn", (Object)this.isIncludeDetailsColumn());
        json.put((Object)"saveInSession", (Object)this.isSaveInSession());
        return json;
    }

    @Override
    public ExecuteSqlCommand copy() {
        return new ExecuteSqlCommand(this);
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != this.getSorts() && this.getSorts().size() > 0) {
            params.put("query.sort", Sort.getSortQueryStringParam(this.getSorts()));
        }
        for (Map.Entry<String, String> entry : this.getQueryParameters().entrySet()) {
            params.put("query.param." + entry.getKey(), entry.getValue());
        }
        return params;
    }
}

