/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.assay.nab.model;

import java.util.List;
import java.util.Map;
import org.labkey.remoteapi.assay.nab.model.NAbCurveParameters;
import org.labkey.remoteapi.assay.nab.model.NAbNeutralizationResult;
import org.labkey.remoteapi.assay.nab.model.NAbReplicate;

public class NAbSample {
    private Map<String, Object> _properties;
    private String _wellgroupName;
    private Long _minDilution;
    private Long _maxDilution;
    private long _objectId;
    private Double _fitError;
    private NAbCurveParameters _fitParameters;
    private NAbReplicate[] _replicates;
    private NAbNeutralizationResult[] _neutralizationResults;

    public NAbSample(Map<String, Object> properties, long[] cutoffs) {
        this._properties = (Map)properties.get("properties");
        this._wellgroupName = (String)properties.get("wellgroupName");
        this._objectId = ((Number)properties.get("objectId")).longValue();
        if (properties.containsKey("minDilution")) {
            this._minDilution = ((Number)properties.get("minDilution")).longValue();
            this._maxDilution = ((Number)properties.get("maxDilution")).longValue();
        }
        if (properties.containsKey("fitError")) {
            this._fitError = ((Number)properties.get("fitError")).doubleValue();
        }
        if (properties.containsKey("fitParameters")) {
            this._fitParameters = new NAbCurveParameters((Map)properties.get("fitParameters"));
        }
        if (properties.containsKey("replicates")) {
            List replicates = (List)properties.get("replicates");
            this._replicates = new NAbReplicate[replicates.size()];
            for (int i = 0; i < replicates.size(); ++i) {
                this._replicates[i] = new NAbReplicate((Map)replicates.get(i));
            }
        }
        if (cutoffs != null && cutoffs.length > 0 && properties.containsKey("curveIC" + cutoffs[0])) {
            this._neutralizationResults = new NAbNeutralizationResult[cutoffs.length];
            for (int i = 0; i < cutoffs.length; ++i) {
                long cutoff = cutoffs[i];
                double curveBasedDilution = this.convert(properties.get("curveIC" + cutoff));
                double pointBasedDilution = this.convert(properties.get("pointIC" + cutoff));
                this._neutralizationResults[i] = new NAbNeutralizationResult(cutoff, curveBasedDilution, pointBasedDilution);
            }
        }
    }

    private double convert(Object ic) {
        return ic instanceof Number ? ((Number)ic).doubleValue() : Double.valueOf((String)ic).doubleValue();
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public String getWellgroupName() {
        return this._wellgroupName;
    }

    public Long getMinDilution() {
        return this._minDilution;
    }

    public Long getMaxDilution() {
        return this._maxDilution;
    }

    public Double getFitError() {
        return this._fitError;
    }

    public NAbCurveParameters getFitParameters() {
        return this._fitParameters;
    }

    public NAbReplicate[] getReplicates() {
        return this._replicates;
    }

    public NAbNeutralizationResult[] getNeutralizationResults() {
        return this._neutralizationResults;
    }

    public long getObjectId() {
        return this._objectId;
    }
}

