/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.assay;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.PostCommand;
import org.labkey.remoteapi.assay.ImportRunResponse;

public class ImportRunCommand
extends PostCommand<ImportRunResponse> {
    private boolean _useJson = false;
    private int _batchId;
    private int _assayId;
    private String _name;
    private String _comment;
    private Map<String, Object> _properties;
    private Map<String, Object> _batchProperties;
    private File _file;

    public ImportRunCommand(int assayId, File file) {
        super("assay", "importRun");
        this._assayId = assayId;
        this._file = file;
    }

    public void setUseJson(boolean useJson) {
        this._useJson = useJson;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setProperties(Map<String, Object> properties) {
        this._properties = properties;
    }

    public void setBatchId(int batchId) {
        this._batchId = batchId;
    }

    public void setBatchProperties(Map<String, Object> batchProperties) {
        this._batchProperties = batchProperties;
    }

    @Override
    public ImportRunCommand copy() {
        ImportRunCommand cmd = new ImportRunCommand(this._assayId, this._file);
        cmd._useJson = this._useJson;
        cmd._name = this._name;
        cmd._comment = this._comment;
        cmd._properties = this._properties;
        cmd._batchId = this._batchId;
        cmd._batchProperties = this._batchProperties;
        return cmd;
    }

    @Override
    protected ImportRunResponse createResponse(String text, int status, String contentType, JSONObject json) {
        return new ImportRunResponse(text, status, contentType, json, this);
    }

    @Override
    protected HttpUriRequest createRequest(URI uri) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (this._assayId == 0) {
            throw new IllegalArgumentException("assay id required");
        }
        if (this._file == null) {
            throw new IllegalArgumentException("file required");
        }
        if (this._useJson) {
            JSONObject json = new JSONObject();
            json.put((Object)"apiVersion", (Object)this.getRequiredVersion());
            json.put((Object)"assayId", (Object)this._assayId);
            if (this._batchId > 0) {
                json.put((Object)"batchId", (Object)this._batchId);
            }
            if (this._name != null) {
                json.put((Object)"name", (Object)this._name);
            }
            if (this._comment != null) {
                json.put((Object)"comment", (Object)this._comment);
            }
            if (this._properties != null) {
                json.put((Object)"properties", this._properties);
            }
            if (this._batchProperties != null) {
                json.put((Object)"batchProperties", this._batchProperties);
            }
            builder.addTextBody("json", json.toJSONString(), ContentType.APPLICATION_JSON);
        } else {
            builder.addTextBody("assayId", String.valueOf(this._assayId));
            if (this._batchId > 0) {
                builder.addTextBody("batchId", String.valueOf(this._batchId));
            }
            if (this._name != null) {
                builder.addTextBody("name", String.valueOf(this._name));
            }
            if (this._comment != null) {
                builder.addTextBody("comment", String.valueOf(this._comment));
            }
            if (this._properties != null) {
                for (Map.Entry entry : this._properties.entrySet()) {
                    builder.addTextBody("properties[" + (String)entry.getKey() + "]", String.valueOf(entry.getValue()));
                }
            }
            if (this._batchProperties != null) {
                for (Map.Entry entry : this._batchProperties.entrySet()) {
                    builder.addTextBody("batchProperties[" + (String)entry.getKey() + "]", String.valueOf(entry.getValue()));
                }
            }
        }
        builder.addBinaryBody("file", this._file, ContentType.APPLICATION_OCTET_STREAM, this._file.getName());
        HttpPost post = new HttpPost(uri);
        post.setEntity(builder.build());
        return post;
    }
}

