/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.CommandResponse;

public class PostCommand<ResponseType extends CommandResponse>
extends Command<ResponseType> {
    private JSONObject _jsonObject = null;

    public PostCommand(String controllerName, String actionName) {
        super(controllerName, actionName);
    }

    public PostCommand(PostCommand source) {
        super(source);
        if (null != source.getJsonObject()) {
            this._jsonObject = source.getJsonObject();
        }
    }

    public JSONObject getJsonObject() {
        return this._jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    @Override
    protected HttpUriRequest createRequest(URI uri) {
        HttpPost request = new HttpPost(uri);
        JSONObject json = this.getJsonObject();
        if (null != json) {
            if (!json.containsKey((Object)"apiVersion")) {
                json.put((Object)"apiVersion", (Object)this.getRequiredVersion());
            }
            request.setEntity((HttpEntity)new StringEntity(json.toString(), ContentType.APPLICATION_JSON));
        }
        return request;
    }

    @Override
    public PostCommand copy() {
        return new PostCommand<ResponseType>(this);
    }
}

