/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.labkey.remoteapi.BasicAuthCredentialsProvider;
import org.labkey.remoteapi.CredentialsProvider;
import org.labkey.remoteapi.GuestCredentialsProvider;
import org.labkey.remoteapi.NetrcFileParser;

public class NetrcCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider _wrappedCredentialsProvider;

    public NetrcCredentialsProvider(URI baseURI) throws IOException {
        this(baseURI.getHost());
    }

    public NetrcCredentialsProvider(String host) throws IOException {
        NetrcFileParser parser = new NetrcFileParser();
        NetrcFileParser.NetrcEntry entry = parser.getEntry(host);
        this._wrappedCredentialsProvider = null != entry ? new BasicAuthCredentialsProvider(entry.getLogin(), entry.getPassword()) : new GuestCredentialsProvider();
    }

    @Override
    public void configureRequest(String baseUrl, HttpUriRequest request, HttpClientContext httpClientContext) throws AuthenticationException, URISyntaxException {
        this._wrappedCredentialsProvider.configureRequest(baseUrl, request, httpClientContext);
    }
}

