/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.labkey.remoteapi.BasicAuthCredentialsProvider;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.CredentialsProvider;
import org.labkey.remoteapi.NetrcCredentialsProvider;
import org.labkey.remoteapi.security.EnsureLoginCommand;

public class Connection {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final HttpClientConnectionManager _connectionManager = new PoolingHttpClientConnectionManager();
    private final String _baseUrl;
    private final CredentialsProvider _credentialsProvider;
    private final HttpClientContext _httpClientContext;
    private final Map<Integer, CloseableHttpClient> _clientMap = new HashMap<Integer, CloseableHttpClient>(3);
    private boolean _acceptSelfSignedCerts;
    private int _timeout = 60000;
    private String csrf = null;

    public Connection(String baseUrl, CredentialsProvider credentialsProvider) {
        this._baseUrl = baseUrl;
        this._credentialsProvider = credentialsProvider;
        this._httpClientContext = HttpClientContext.create();
        this._httpClientContext.setCookieStore((CookieStore)new BasicCookieStore());
        this.setAcceptSelfSignedCerts(false);
    }

    public Connection(String baseUrl) throws URISyntaxException, IOException {
        this(baseUrl, new NetrcCredentialsProvider(new URI(baseUrl)));
    }

    public Connection(String baseUrl, String email, String password) {
        this(baseUrl, new BasicAuthCredentialsProvider(email, password));
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public boolean isAcceptSelfSignedCerts() {
        return this._acceptSelfSignedCerts;
    }

    public void setAcceptSelfSignedCerts(boolean acceptSelfSignedCerts) {
        this._acceptSelfSignedCerts = acceptSelfSignedCerts;
        this._clientMap.clear();
    }

    public CloseableHttpClient getHttpClient(int timeout) {
        CloseableHttpClient client = this._clientMap.get(timeout);
        if (null == client) {
            HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager(_connectionManager).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(timeout).build()).setDefaultCookieStore(this._httpClientContext.getCookieStore());
            if (this._acceptSelfSignedCerts) {
                try {
                    SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                    sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                    SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build());
                    builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
            client = builder.build();
            this._clientMap.put(timeout, client);
        }
        return client;
    }

    protected void beforeExecute(HttpRequest request) {
        if (null == this.csrf && request instanceof HttpPost) {
            try {
                new Command("login", "login").execute(this, "/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.csrf) {
            request.setHeader("X-LABKEY-CSRF", this.csrf);
        }
    }

    protected void afterExecute() {
        if (null == this.csrf) {
            for (Cookie c : this._httpClientContext.getCookieStore().getCookies()) {
                if (!"JSESSIONID".equals(c.getName())) continue;
                this.csrf = c.getValue();
            }
        }
    }

    public CloseableHttpClient ensureAuthenticated() throws IOException, AuthenticationException, CommandException {
        EnsureLoginCommand command = new EnsureLoginCommand();
        Object response = command.execute(this, "/home");
        return this.getHttpClient(this.getTimeout());
    }

    CloseableHttpResponse executeRequest(HttpUriRequest request, Integer timeout) throws IOException, URISyntaxException, AuthenticationException {
        this._credentialsProvider.configureRequest(this.getBaseUrl(), request, this._httpClientContext);
        int clientTimeout = null == timeout ? this.getTimeout() : timeout.intValue();
        CloseableHttpClient client = this.getHttpClient(clientTimeout);
        this.beforeExecute((HttpRequest)request);
        CloseableHttpResponse response = client.execute(request, (HttpContext)this._httpClientContext);
        this.afterExecute();
        return response;
    }

    public void setTimeout(Integer timeout) {
        this._timeout = timeout;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void addCookie(String name, String value, String domain, String path, Date expiry, boolean isSecure) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setExpiryDate(expiry);
        cookie.setSecure(isSecure);
        this._httpClientContext.getCookieStore().addCookie((Cookie)cookie);
    }
}

