/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.labkey.remoteapi.Command;

public class CommandResponse {
    private String _text;
    private int _statusCode;
    private String _contentType;
    private JSONObject _data = null;
    private Command _sourceCommand;

    public CommandResponse(String text, int statusCode, String contentType, JSONObject json, Command sourceCommand) {
        this._text = text;
        this._statusCode = statusCode;
        this._contentType = contentType;
        this._data = json;
        this._sourceCommand = sourceCommand;
    }

    public String getText() {
        return this._text;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getContentType() {
        return this._contentType;
    }

    public double getRequiredVersion() {
        return this._sourceCommand.getRequiredVersion();
    }

    public Command getSourceCommand() {
        return this._sourceCommand;
    }

    public Map<String, Object> getParsedData() {
        if (null == this._data && null != this.getText() && null != this._contentType && this._contentType.contains("application/json")) {
            this._data = (JSONObject)JSONValue.parse((String)this.getText());
        }
        return this._data;
    }

    public <T> T getProperty(String path) {
        assert (null != path);
        String[] pathParts = path.split("\\.");
        if (null == pathParts || pathParts.length == 0) {
            return null;
        }
        return this.getProperty(pathParts, 0, this.getParsedData());
    }

    protected <T> T getProperty(String[] path, int index, Map<String, Object> parent) {
        if (null == parent) {
            return null;
        }
        Object prop = parent.get(path[index]);
        if (index == path.length - 1) {
            return (T)prop;
        }
        return null != prop && prop instanceof Map ? (T)this.getProperty(path, index + 1, (Map)prop) : null;
    }

    protected Map<String, Object> findObject(List<Map<String, Object>> objects, String propertyName, String value) {
        assert (null != value);
        for (Map<String, Object> obj : objects) {
            if (!value.equalsIgnoreCase(String.valueOf(obj.get(propertyName)))) continue;
            return obj;
        }
        return null;
    }
}

