/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.labkey.remoteapi.ApiVersionException;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.Connection;

public class Command<ResponseType extends CommandResponse> {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private final String _controllerName;
    private final String _actionName;
    private Map<String, Object> _parameters = null;
    private Integer _timeout = null;
    private double _requiredVersion = 8.3;

    public Command(String controllerName, String actionName) {
        assert (null != controllerName);
        assert (null != actionName);
        this._controllerName = controllerName;
        this._actionName = actionName;
    }

    public Command(Command<ResponseType> source) {
        this._actionName = source.getActionName();
        this._controllerName = source.getControllerName();
        if (null != source.getParameters()) {
            this._parameters = new HashMap<String, Object>(source.getParameters());
        }
        this._timeout = source._timeout;
        this._requiredVersion = source.getRequiredVersion();
    }

    public String getControllerName() {
        return this._controllerName;
    }

    public String getActionName() {
        return this._actionName;
    }

    public Map<String, Object> getParameters() {
        if (null == this._parameters) {
            this._parameters = new HashMap<String, Object>();
        }
        return this._parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this._parameters = parameters;
    }

    public Integer getTimeout() {
        return this._timeout;
    }

    public void setTimeout(Integer timeout) {
        this._timeout = timeout;
    }

    public ResponseType execute(Connection connection, String folderPath) throws IOException, CommandException {
        try (Response response = this._execute(connection, folderPath);){
            JSONObject json = null;
            String responseText = null;
            String contentType = response.getContentType();
            if (null != contentType && contentType.contains(CONTENT_TYPE_JSON)) {
                json = (JSONObject)JSONValue.parse((Reader)new BufferedReader(new InputStreamReader(response.getInputStream())));
            } else {
                responseText = response.getText();
            }
            ResponseType ResponseType = this.createResponse(responseText, response.getStatusCode(), contentType, json);
            return ResponseType;
        }
    }

    protected Response _execute(Connection connection, String folderPath) throws CommandException, IOException {
        CloseableHttpResponse httpResponse;
        assert (null != this.getControllerName()) : "You must set the controller name before executing the command!";
        assert (null != this.getActionName()) : "You must set the action name before executing the command!";
        try {
            HttpUriRequest request = this.getHttpRequest(connection, folderPath);
            LogFactory.getLog(Command.class).info((Object)("Requesting URL: " + request.getURI().toString()));
            httpResponse = connection.executeRequest(request, this.getTimeout());
        }
        catch (URISyntaxException | AuthenticationException e) {
            throw new CommandException(e.getMessage());
        }
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        String contentType = null == contentTypeHeader ? null : contentTypeHeader.getValue();
        Response response = new Response(httpResponse, contentType);
        int status = response.getStatusCode();
        if (status >= 400 && status < 600) {
            this.throwError(response);
        }
        return response;
    }

    private void throwError(Response r) throws IOException, CommandException {
        String message = null != r.getStatusText() ? r.getStatusText() : "(no status text)";
        String responseText = r.getText();
        JSONObject json = null;
        String contentType = r.getContentType();
        if (null != contentType && contentType.contains(CONTENT_TYPE_JSON) && responseText != null && responseText.length() > 0 && (json = (JSONObject)JSONValue.parse((String)responseText)) != null && json.containsKey((Object)"exception")) {
            message = (String)json.get((Object)"exception");
            if ("org.labkey.api.action.ApiVersionException".equals(json.get((Object)"exceptionClass"))) {
                throw new ApiVersionException(message, r.getStatusCode(), (Map<String, Object>)json, responseText);
            }
        }
        throw new CommandException(message, r.getStatusCode(), (Map<String, Object>)json, responseText);
    }

    protected ResponseType createResponse(String text, int status, String contentType, JSONObject json) {
        return (ResponseType)new CommandResponse(text, status, contentType, json, this.copy());
    }

    protected HttpUriRequest getHttpRequest(Connection connection, String folderPath) throws CommandException, URISyntaxException {
        URI uri = this.getActionUrl(connection, folderPath);
        String queryString = this.getQueryString();
        if (null != queryString) {
            uri = new URIBuilder(uri).setQuery(queryString).build();
        }
        return this.createRequest(uri);
    }

    protected HttpUriRequest createRequest(URI uri) {
        return new HttpGet(uri);
    }

    protected URI getActionUrl(Connection connection, String folderPath) throws URISyntaxException {
        String actionName;
        URI uri = new URI(connection.getBaseUrl().replace('\\', '/'));
        StringBuilder path = new StringBuilder(uri.getPath() == null || "".equals(uri.getPath()) ? "/" : uri.getPath());
        String controller = this.getControllerName();
        if (controller.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(controller);
        if (null != folderPath && folderPath.length() > 0) {
            String folderPathNormalized = folderPath.replace('\\', '/');
            if (folderPathNormalized.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
                path.append('/');
            }
            path.append(folderPathNormalized);
        }
        if ((actionName = this.getActionName()).charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(actionName);
        if (!actionName.endsWith(".api")) {
            path.append(".api");
        }
        return new URIBuilder(uri).setPath(path.toString()).build();
    }

    protected String getQueryString() throws CommandException {
        Map<String, Object> params = this.getParameters();
        if (this.getRequiredVersion() > 0.0) {
            params.put(CommonParameters.apiVersion.name(), this.getRequiredVersion());
        }
        StringBuilder qstring = new StringBuilder();
        URLCodec urlCodec = new URLCodec();
        try {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        this.appendParameter(qstring, urlCodec, name, o);
                    }
                    continue;
                }
                this.appendParameter(qstring, urlCodec, name, value);
            }
        }
        catch (EncoderException e) {
            throw new CommandException(e.getMessage());
        }
        return qstring.length() > 0 ? qstring.toString() : null;
    }

    private void appendParameter(StringBuilder qstring, URLCodec urlCodec, String name, Object value) throws EncoderException {
        String strValue;
        String string = strValue = null == value ? null : this.getParamValueAsString(value, name);
        if (null != strValue) {
            if (qstring.length() > 0) {
                qstring.append('&');
            }
            qstring.append(urlCodec.encode(name));
            qstring.append('=');
            qstring.append(urlCodec.encode(strValue));
        }
    }

    protected String getParamValueAsString(Object param, String name) {
        return param.toString();
    }

    public double getRequiredVersion() {
        return this._requiredVersion;
    }

    public void setRequiredVersion(double requiredVersion) {
        this._requiredVersion = requiredVersion;
    }

    public Command copy() {
        return new Command<ResponseType>(this);
    }

    protected static class Response
    implements Closeable {
        private final CloseableHttpResponse _httpResponse;
        private final String _contentType;

        private Response(CloseableHttpResponse httpResponse, String contentType) {
            this._httpResponse = httpResponse;
            this._contentType = contentType;
        }

        public String getStatusText() {
            return this._httpResponse.getStatusLine().getReasonPhrase();
        }

        public int getStatusCode() {
            return this._httpResponse.getStatusLine().getStatusCode();
        }

        public String getContentType() {
            return this._contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this._httpResponse.getEntity().getContent();
        }

        public String getText() throws IOException {
            try (Scanner s = null;){
                s = new Scanner(this._httpResponse.getEntity().getContent()).useDelimiter("\\A");
                String string = s.hasNext() ? s.next() : "";
                return string;
            }
        }

        @Override
        public void close() throws IOException {
            this._httpResponse.close();
        }
    }

    public static enum CommonParameters {
        apiVersion;

    }
}

