/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.labkey.remoteapi.CredentialsProvider;

public class BasicAuthCredentialsProvider
implements CredentialsProvider {
    private final String _email;
    private final String _password;

    public BasicAuthCredentialsProvider(String email, String password) {
        this._email = email;
        this._password = password;
    }

    @Override
    public void configureRequest(String baseUrl, HttpUriRequest request, HttpClientContext httpClientContext) throws AuthenticationException, URISyntaxException {
        AuthScope scope = new AuthScope(new URI(baseUrl).getHost(), -1, AuthScope.ANY_REALM);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this._email, this._password);
        provider.setCredentials(scope, (Credentials)credentials);
        httpClientContext.setCredentialsProvider((org.apache.http.client.CredentialsProvider)provider);
        request.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)request, (HttpContext)httpClientContext));
    }
}

