/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.test;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.assay.Batch;
import org.labkey.remoteapi.assay.Data;
import org.labkey.remoteapi.assay.Run;
import org.labkey.remoteapi.assay.SaveAssayBatchCommand;
import org.labkey.remoteapi.ms2.StartSearchCommand;
import org.labkey.remoteapi.test.ClientConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MS2SearchClient {
    public static void main(String ... args) throws Exception {
        ClientConfig config = new ClientConfig(args);
        int assayId = MS2SearchClient.getAssayId(config);
        HashMap<String, Batch> batches = new HashMap<String, Batch>();
        HashMap<SearchInfo, List<String>> searches = new HashMap<SearchInfo, List<String>>();
        MS2SearchClient.parseCSVs(args, batches, searches);
        Connection connection = config.createConnection();
        try {
            MS2SearchClient.submitAssayBatches(assayId, batches, connection);
            MS2SearchClient.submitSearches(config, searches, connection);
        }
        catch (CommandException e) {
            System.err.println("Failure! Response code: " + e.getStatusCode());
            e.printStackTrace();
            System.err.println();
            if (e.getResponseText() != null) {
                System.err.println("Response text: ");
                System.err.println(e.getResponseText());
            }
            System.exit(1);
        }
    }

    private static void submitSearches(ClientConfig config, Map<SearchInfo, List<String>> searches, Connection connection) throws IOException, CommandException {
        String pipelineRoot = config.getProperty("pipelineRoot");
        String searchEngineName = config.getProperty("searchEngine");
        StartSearchCommand.SearchEngine searchEngine = null;
        for (StartSearchCommand.SearchEngine engine : StartSearchCommand.SearchEngine.values()) {
            if (!engine.name().equalsIgnoreCase(searchEngineName)) continue;
            searchEngine = engine;
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException("searchEngine '" + searchEngineName + "' is not one of the available options: " + Arrays.asList(StartSearchCommand.SearchEngine.values()));
        }
        for (Map.Entry<SearchInfo, List<String>> entry : searches.entrySet()) {
            SearchInfo searchInfo = entry.getKey();
            String fullPath = searchInfo.getPath();
            if (!fullPath.toLowerCase().startsWith(pipelineRoot.toLowerCase())) {
                throw new IllegalArgumentException("Could not determine relative path for '" + fullPath);
            }
            String relativePath = fullPath.substring(pipelineRoot.length());
            if (!(relativePath = relativePath.replace('\\', '/')).startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            List<String> fileNames = entry.getValue();
            System.out.print("Submitting search using protocol " + searchInfo.getProtocol() + " to " + searchInfo.getFolder() + ", with " + fileNames.size() + " files");
            StartSearchCommand startCommand = new StartSearchCommand(searchEngine, searchInfo.getProtocol(), relativePath, fileNames);
            startCommand.execute(connection, searchInfo.getFolder());
        }
    }

    private static void submitAssayBatches(int assayId, Map<String, Batch> batches, Connection connection) throws IOException, CommandException {
        for (Map.Entry<String, Batch> entry : batches.entrySet()) {
            Batch batch = entry.getValue();
            String targetFolder = entry.getKey();
            SaveAssayBatchCommand command = new SaveAssayBatchCommand(assayId, batch);
            System.out.print("Submitting metadata from " + batch + " to " + targetFolder + ", describing " + batch.getRuns().size() + " files");
            command.execute(connection, targetFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCSVs(String[] args, Map<String, Batch> batches, Map<SearchInfo, List<String>> searches) throws IOException {
        for (String arg : args) {
            List lines;
            if (arg.startsWith("-")) continue;
            File csvFile = new File(arg);
            System.out.println("Processing " + csvFile);
            FileInputStream in = new FileInputStream(csvFile);
            try {
                InputStreamReader reader = new InputStreamReader(in);
                CSVReader csvReader = new CSVReader((Reader)reader, ',', '\"', '~');
                lines = csvReader.readAll();
            }
            finally {
                ((InputStream)in).close();
            }
            if (lines.size() < 2) {
                throw new IllegalArgumentException("Expected to have at least two rows in CSV, one with headers and others with data in " + csvFile.getPath());
            }
            String[] headers = (String[])lines.get(0);
            for (int i = 1; i < lines.size(); ++i) {
                String[] line = (String[])lines.get(i);
                boolean blankLink = true;
                for (String value : line) {
                    if (value == null || value.trim().isEmpty()) continue;
                    blankLink = false;
                    break;
                }
                if (blankLink) continue;
                String fileName = MS2SearchClient.getValue(line, headers, "FileName", i);
                String path = MS2SearchClient.getValue(line, headers, "Path", i);
                String sample = MS2SearchClient.getValue(line, headers, "Sample", i);
                String folder = MS2SearchClient.getValue(line, headers, "LabKeyFolder", i);
                String protocol = MS2SearchClient.getValue(line, headers, "ProtocolToRun", i);
                HashMap<String, String> runProperties = new HashMap<String, String>();
                for (int columnIndex = 0; columnIndex < line.length; ++columnIndex) {
                    runProperties.put(headers[columnIndex], line[columnIndex]);
                }
                Batch batch = batches.get(folder);
                if (batch == null) {
                    batch = new Batch();
                    batch.setName(csvFile.getName());
                    batches.put(folder, batch);
                }
                MS2SearchClient.addRunToBatch(batch, fileName, path, runProperties);
                SearchInfo info = new SearchInfo(sample, protocol, folder, path);
                List<String> files = searches.get(info);
                if (files == null) {
                    files = new ArrayList<String>();
                    searches.put(info, files);
                }
                files.add(fileName);
            }
        }
    }

    private static int getAssayId(ClientConfig config) {
        int assayId;
        String assayIdString = config.getProperty("assayId");
        try {
            assayId = Integer.parseInt(assayIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse assayId: " + assayIdString, e);
        }
        return assayId;
    }

    private static String getValue(String[] line, String[] headers, String columnName, int lineNumber) {
        int columnIndex = MS2SearchClient.findIndex(headers, columnName);
        if (columnIndex >= line.length) {
            throw new IllegalArgumentException("Row " + lineNumber + " is incomplete in CSV file. It contains fewer columns than the header does.");
        }
        String result = line[columnIndex];
        if (result == null || result.trim().equals("")) {
            throw new IllegalArgumentException("Row " + lineNumber + " is incomplete in CSV file, it does not include a value for '" + columnName + "'");
        }
        return result.trim();
    }

    private static void addRunToBatch(Batch batch, String fileName, String path, Map<String, String> runProperties) {
        Run run = new Run();
        run.setName(fileName);
        run.getProperties().putAll(runProperties);
        batch.getRuns().add(run);
        ArrayList<Data> outputFiles = new ArrayList<Data>();
        Data data = new Data();
        data.setAbsolutePath(path + File.separator + fileName);
        outputFiles.add(data);
        run.setDataOutputs(outputFiles);
    }

    private static int findIndex(String[] headers, String propertyName) {
        for (int i = 0; i < headers.length; ++i) {
            if (!propertyName.equalsIgnoreCase(headers[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find required property '" + propertyName + "' in input CSV file");
    }

    private static class SearchInfo {
        private String _sample;
        private String _protocol;
        private String _folder;
        private String _path;

        private SearchInfo(String sample, String protocol, String folder, String path) {
            this._sample = sample;
            this._protocol = protocol;
            this._folder = folder;
            this._path = path;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public String getFolder() {
            return this._folder;
        }

        public String getPath() {
            return this._path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SearchInfo)) {
                return false;
            }
            SearchInfo that = (SearchInfo)o;
            if (this._folder == null ? that._folder != null : !this._folder.equals(that._folder)) {
                return false;
            }
            if (this._path == null ? that._path != null : !this._path.equals(that._path)) {
                return false;
            }
            if (this._protocol == null ? that._protocol != null : !this._protocol.equals(that._protocol)) {
                return false;
            }
            return this._sample == null ? that._sample == null : this._sample.equals(that._sample);
        }

        public int hashCode() {
            int result = this._sample == null ? 0 : this._sample.hashCode();
            result = 31 * result + (this._protocol == null ? 0 : this._protocol.hashCode());
            result = 31 * result + (this._folder == null ? 0 : this._folder.hashCode());
            result = 31 * result + (this._path == null ? 0 : this._path.hashCode());
            return result;
        }
    }
}

