/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.security;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.PostCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupMembersCommand
extends PostCommand<CommandResponse> {
    private int _groupId = -1;
    private List<Integer> _principals = new ArrayList<Integer>();

    protected GroupMembersCommand(String actionName, int groupId) {
        super("security", actionName);
        this._groupId = groupId;
    }

    protected GroupMembersCommand(GroupMembersCommand source) {
        super(source);
        this._groupId = source.getGroupId();
        this._principals.addAll(source.getPrincipals());
    }

    public List<Integer> getPrincipals() {
        return this._principals;
    }

    public void addPrincipalId(int ... ids) {
        for (int id : ids) {
            this._principals.add(new Integer(id));
        }
    }

    public void addPrincipalId(List<Integer> ids) {
        for (int id : ids) {
            this._principals.add(new Integer(id));
        }
    }

    public void clearPrincipalIds() {
        this._principals.clear();
    }

    public int getGroupId() {
        return this._groupId;
    }

    public void setGroupId(int groupId) {
        this._groupId = groupId;
    }

    @Override
    public JSONObject getJsonObject() {
        assert (this.getGroupId() > 0) : "forgot to set group id!";
        assert (this._principals.size() > 0) : "forgot to add principal id(s)!";
        JSONObject obj = new JSONObject();
        obj.put((Object)"groupId", (Object)this.getGroupId());
        obj.put((Object)"principalIds", this._principals);
        return obj;
    }
}

