/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.io.IOException;
import org.labkey.remoteapi.ApiVersionException;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.query.BaseSelect;
import org.labkey.remoteapi.query.ContainerFilter;
import org.labkey.remoteapi.query.SelectRowsResponse;
import org.labkey.remoteapi.sas.SASConnection;

public class SASBaseSelectCommand {
    protected BaseSelect _command;

    protected SASBaseSelectCommand(BaseSelect command) {
        this._command = command;
    }

    public void setMaxRows(double maxRows) {
        int max = (int)Math.round(maxRows);
        this._command.setMaxRows(max);
    }

    public void setOffset(double offset) {
        int off = (int)Math.round(offset);
        this._command.setOffset(off);
    }

    public void setContainerFilter(String filterString) {
        ContainerFilter containerFilter = ContainerFilter.valueOf(filterString);
        this._command.setContainerFilter(containerFilter);
    }

    protected SelectRowsResponse execute(SASConnection cn, String folderPath) throws CommandException, IOException {
        this._command.setRequiredVersion(9.1);
        try {
            return this._command.execute(cn, folderPath);
        }
        catch (ApiVersionException apiVersionException) {
            this._command.setRequiredVersion(8.3);
            return this._command.execute(cn, folderPath);
        }
    }
}

