/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetrcFileParser {
    private static Pattern netrcPattern = Pattern.compile("machine\\s+(.+?)\\s+login\\s+(.+?)\\s+password\\s+(.+?)\\s+", 8);

    public NetrcEntry getEntry(String host) throws IOException {
        NetrcEntry entry = this.getEntry(".netrc", host);
        if (null != entry) {
            return entry;
        }
        return this.getEntry("_netrc", host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetrcEntry getEntry(String netrcName, String host) throws IOException {
        File netrcFile = new File(System.getProperty("user.home") + "/" + netrcName);
        if (!netrcFile.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            input = new BufferedReader(new FileReader(netrcFile));
            while ((line = input.readLine()) != null) {
                sb.append(line).append('\n');
            }
            Matcher m = netrcPattern.matcher(sb);
            int index = 0;
            while (m.find(index)) {
                if (3 == m.groupCount() && m.group(1).equals(host)) {
                    NetrcEntry netrcEntry = new NetrcEntry(m.group(1), m.group(2), m.group(3));
                    return netrcEntry;
                }
                index = m.end();
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ioe) {}
        }
        return null;
    }

    public class NetrcEntry {
        private String _machine;
        private String _login;
        private String _password;

        private NetrcEntry(String machine, String login, String password) {
            this._machine = machine;
            this._login = login;
            this._password = password;
        }

        public String getMachine() {
            return this._machine;
        }

        public String getLogin() {
            return this._login;
        }

        public String getPassword() {
            return this._password;
        }
    }
}

