/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.query.jdbc.LabKeyConnection;

public class LabKeyDriver
implements Driver {
    private static final String URL_PREFIX = "jdbc:labkey:";

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(URL_PREFIX);
    }

    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        if (url.startsWith(URL_PREFIX)) {
            url = url.substring(URL_PREFIX.length());
        }
        String user = info.getProperty("user");
        String password = info.getProperty("password");
        Connection connection = user != null && password != null ? new Connection(url, user, password) : new Connection(url);
        LabKeyConnection labKeyConnection = new LabKeyConnection(connection);
        labKeyConnection.setClientInfo(info);
        return labKeyConnection;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            DriverManager.registerDriver(new LabKeyDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

