/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.query.GetQueriesCommand;
import org.labkey.remoteapi.query.GetQueriesResponse;
import org.labkey.remoteapi.query.GetQueryDetailsCommand;
import org.labkey.remoteapi.query.GetQueryDetailsResponse;
import org.labkey.remoteapi.query.GetSchemasCommand;
import org.labkey.remoteapi.query.GetSchemasResponse;
import org.labkey.remoteapi.query.jdbc.BaseJDBC;
import org.labkey.remoteapi.query.jdbc.LabKeyConnection;
import org.labkey.remoteapi.query.jdbc.LabKeyResultSet;
import org.labkey.remoteapi.security.GetContainersCommand;
import org.labkey.remoteapi.security.GetContainersResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabKeyDatabaseMetaData
extends BaseJDBC
implements DatabaseMetaData {
    private static final Logger _log = Logger.getLogger("test");
    private final LabKeyConnection _connection;

    public LabKeyDatabaseMetaData(LabKeyConnection connection) {
        this._connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this._connection.getConnection().getBaseUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this._connection.getConnection().getEmail();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "LabKey Server";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "0.01";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "LabKey";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "0.01";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "%";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "container";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        _log.log(Level.INFO, "getTables: " + catalog + ", " + schemaPattern + ", " + tableNamePattern);
        this._connection.setCatalog(catalog);
        if (schemaPattern != null && (schemaPattern.indexOf("%") != -1 || schemaPattern.indexOf("_") != -1)) {
            throw new IllegalArgumentException("schemaPattern must request an exact match, but was: " + schemaPattern);
        }
        if (!(tableNamePattern == null || tableNamePattern.equals("%") || tableNamePattern.indexOf("%") == -1 && tableNamePattern.indexOf("_") == -1)) {
            throw new IllegalArgumentException("tableNamePattern must request an exact match, but was: " + tableNamePattern);
        }
        try {
            List<String> schemaNames;
            if (schemaPattern != null) {
                schemaNames = Collections.singletonList(schemaPattern);
            } else {
                GetSchemasCommand command = new GetSchemasCommand();
                GetSchemasResponse response = (GetSchemasResponse)command.execute(this._connection.getConnection(), this._connection.getFolderPath());
                schemaNames = response.getSchemaNames();
            }
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            for (String schemaName : schemaNames) {
                GetQueriesCommand command = new GetQueriesCommand(schemaName);
                GetQueriesResponse response = (GetQueriesResponse)command.execute(this._connection.getConnection(), this._connection.getFolderPath());
                for (String table : response.getQueryNames()) {
                    if (!this.matches(table, tableNamePattern)) continue;
                    HashMap<String, String> row = new HashMap<String, String>();
                    row.put("TABLE_CAT", catalog);
                    row.put("TABLE_SCHEM", response.getSchemaName());
                    row.put("TABLE_NAME", table);
                    row.put("TABLE_TYPE", "TABLE");
                    row.put("REMARKS", null);
                    row.put("TYPE_CAT", null);
                    row.put("TYPE_SCHEM", null);
                    row.put("TYPE_NAME", null);
                    row.put("SELF_REFERENCING_COL_NAME", null);
                    row.put("REF_GENERATION", null);
                    rows.add(row);
                }
            }
            ArrayList<LabKeyResultSet.Column> columns = new ArrayList<LabKeyResultSet.Column>();
            columns.add(new LabKeyResultSet.Column("TABLE_CAT", String.class));
            columns.add(new LabKeyResultSet.Column("TABLE_SCHEM", String.class));
            columns.add(new LabKeyResultSet.Column("TABLE_NAME", String.class));
            columns.add(new LabKeyResultSet.Column("TABLE_TYPE", String.class));
            columns.add(new LabKeyResultSet.Column("REMARKS", String.class));
            columns.add(new LabKeyResultSet.Column("TYPE_CAT", String.class));
            columns.add(new LabKeyResultSet.Column("TYPE_SCHEM", String.class));
            columns.add(new LabKeyResultSet.Column("TYPE_NAME", String.class));
            columns.add(new LabKeyResultSet.Column("SELF_REFERENCING_COL_NAME", String.class));
            columns.add(new LabKeyResultSet.Column("REF_GENERATION", String.class));
            return new LabKeyResultSet(rows, columns, this._connection);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (CommandException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            GetContainersCommand command = new GetContainersCommand();
            command.setIncludeSubfolders(true);
            GetContainersResponse response = (GetContainersResponse)command.execute(this._connection.getConnection(), "/");
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            this.addCatalog(response.getParsedData(), rows);
            return new LabKeyResultSet(rows, Collections.singletonList(new LabKeyResultSet.Column("TABLE_CAT", String.class)), this._connection);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (CommandException e) {
            throw new SQLException(e);
        }
    }

    private void addCatalog(Map<String, Object> parsedData, List<Map<String, Object>> rows) {
        rows.add(Collections.singletonMap("TABLE_CAT", parsedData.get("path")));
        if (parsedData.containsKey("children")) {
            List children = (List)parsedData.get("children");
            for (Map child : children) {
                this.addCatalog(child, rows);
            }
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        rows.add(Collections.singletonMap("TABLE_TYPE", "TABLE"));
        List<LabKeyResultSet.Column> columns = Collections.singletonList(new LabKeyResultSet.Column("TABLE_TYPE", String.class));
        return new LabKeyResultSet(rows, columns, this._connection);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this._connection.setCatalog(catalog);
        if (schemaPattern == null || schemaPattern.indexOf("%") != -1 || schemaPattern.indexOf("_") != -1) {
            throw new IllegalArgumentException("schemaPattern must request an exact match but was: " + schemaPattern);
        }
        if (tableNamePattern == null || tableNamePattern.indexOf("%") != -1 || tableNamePattern.indexOf("_") != -1) {
            throw new IllegalArgumentException("tableNamePattern must request an exact match but was: " + tableNamePattern);
        }
        if (columnNamePattern != null && !"%".equals(columnNamePattern)) {
            throw new IllegalArgumentException("columnNamePattern must be null");
        }
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        GetQueryDetailsResponse response = this.getQueryDetails(schemaPattern, tableNamePattern);
        int ordinalPosition = 1;
        for (GetQueryDetailsResponse.Column column : response.getColumns()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("TABLE_CAT", catalog);
            row.put("TABLE_SCHEM", response.getSchemaName());
            row.put("TABLE_NAME", response.getName());
            row.put("COLUMN_NAME", column.getName());
            row.put("DATA_TYPE", this.getSQLType(column.getType()));
            row.put("TYPE_NAME", column.getType());
            row.put("COLUMN_SIZE", -1);
            row.put("BUFFER_LENGTH", null);
            row.put("DECIMAL_DIGITS", null);
            row.put("NUM_PREC_RADIX", 10);
            row.put("NULLABLE", column.isNullable() ? 1 : 0);
            row.put("REMARKS", column.getDescription());
            row.put("SQL_DATA_TYPE", null);
            row.put("SQL_DATETIME_SUB", null);
            row.put("CHAR_OCTET_LENGTH", null);
            row.put("ORDINAL_POSITION", ordinalPosition++);
            row.put("SCOPE_CATALOG", null);
            row.put("SCOPE_SCHEMA", null);
            row.put("SCOPE_TABLE", null);
            row.put("SOURCE_DATA_TYPE", null);
            row.put("IS_AUTOINCREMENT", column.isAutoIncrement() ? "YES" : "NO");
            row.put("IS_GENERATEDCOLUMN", column.isCalculated() || column.isAutoIncrement() || !column.isUserEditable() ? "YES" : "NO");
            rows.add(row);
        }
        ArrayList<LabKeyResultSet.Column> cols = new ArrayList<LabKeyResultSet.Column>();
        cols.add(new LabKeyResultSet.Column("TABLE_CAT", String.class));
        cols.add(new LabKeyResultSet.Column("TABLE_SCHEM", String.class));
        cols.add(new LabKeyResultSet.Column("TABLE_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("COLUMN_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("DATA_TYPE", Integer.class));
        cols.add(new LabKeyResultSet.Column("TYPE_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("COLUMN_SIZE", Integer.class));
        cols.add(new LabKeyResultSet.Column("BUFFER_LENGTH", Integer.class));
        cols.add(new LabKeyResultSet.Column("DECIMAL_DIGITS", Integer.class));
        cols.add(new LabKeyResultSet.Column("NUM_PREC_RADIX", Integer.class));
        cols.add(new LabKeyResultSet.Column("NULLABLE", Integer.class));
        cols.add(new LabKeyResultSet.Column("REMARKS", String.class));
        cols.add(new LabKeyResultSet.Column("SQL_DATA_TYPE", Integer.class));
        cols.add(new LabKeyResultSet.Column("SQL_DATETIME_SUB", Integer.class));
        cols.add(new LabKeyResultSet.Column("CHAR_OCTET_LENGTH", Integer.class));
        cols.add(new LabKeyResultSet.Column("ORDINAL_POSITION", Integer.class));
        cols.add(new LabKeyResultSet.Column("SCOPE_CATALOG", String.class));
        cols.add(new LabKeyResultSet.Column("SCOPE_SCHEMA", String.class));
        cols.add(new LabKeyResultSet.Column("SCOPE_TABLE", String.class));
        cols.add(new LabKeyResultSet.Column("SOURCE_DATA_TYPE", Short.class));
        cols.add(new LabKeyResultSet.Column("IS_AUTOINCREMENT", String.class));
        cols.add(new LabKeyResultSet.Column("IS_GENERATEDCOLUMN", String.class));
        return new LabKeyResultSet(rows, cols, this._connection);
    }

    private int getSQLType(String type) {
        if ("Integer".equalsIgnoreCase(type)) {
            return 4;
        }
        if (type.indexOf("String") != -1) {
            return 12;
        }
        if ("Boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if (type.indexOf("Date") != -1) {
            return 91;
        }
        if (type.indexOf("Number") != -1) {
            return 8;
        }
        return 12;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    private GetQueryDetailsResponse getQueryDetails(String schema, String table) throws SQLException {
        GetQueryDetailsCommand command = new GetQueryDetailsCommand(schema, table);
        try {
            return (GetQueryDetailsResponse)command.execute(this._connection.getConnection(), this._connection.getFolderPath());
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (CommandException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        GetQueryDetailsResponse response = this.getQueryDetails(schema, table);
        int keyIndex = 1;
        for (GetQueryDetailsResponse.Column column : response.getColumns()) {
            if (!column.isKeyField()) continue;
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("TABLE_CAT", catalog);
            row.put("TABLE_SCHEM", response.getSchemaName());
            row.put("TABLE_NAME", response.getName());
            row.put("COLUMN_NAME", column.getName());
            row.put("KEY_SEQ", keyIndex++);
            row.put("PK_NAME", null);
            rows.add(row);
        }
        ArrayList<LabKeyResultSet.Column> cols = new ArrayList<LabKeyResultSet.Column>();
        cols.add(new LabKeyResultSet.Column("TABLE_CAT", String.class));
        cols.add(new LabKeyResultSet.Column("TABLE_SCHEM", String.class));
        cols.add(new LabKeyResultSet.Column("TABLE_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("COLUMN_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("KEY_SEQ", Short.class));
        cols.add(new LabKeyResultSet.Column("PK_NAME", String.class));
        return new LabKeyResultSet(rows, cols, this._connection);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        GetQueryDetailsResponse response = this.getQueryDetails(schema, table);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (GetQueryDetailsResponse.Column column : response.getColumns()) {
            if (column.getLookup() == null) continue;
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("PKTABLE_CAT", catalog);
            row.put("PKTABLE_SCHEM", column.getLookup().getSchemaName());
            row.put("PKTABLE_NAME", column.getLookup().getQueryName());
            row.put("PKCOLUMN_NAME", column.getLookup().getKeyColumn());
            row.put("FKTABLE_CAT", column.getLookup().getContainerPath() == null ? catalog : column.getLookup().getContainerPath());
            row.put("FKTABLE_SCHEM", response.getSchemaName());
            row.put("FKTABLE_NAME", response.getName());
            row.put("FKCOLUMN_NAME", column.getName());
            row.put("KEY_SEQ", 1);
            row.put("UPDATE_RULE", 3);
            row.put("DELETE_RULE", 3);
            row.put("FK_NAME", null);
            row.put("PK_NAME", null);
            row.put("DEFERRABILITY", 7);
            rows.add(row);
        }
        ArrayList<LabKeyResultSet.Column> cols = new ArrayList<LabKeyResultSet.Column>();
        cols.add(new LabKeyResultSet.Column("PKTABLE_CAT", String.class));
        cols.add(new LabKeyResultSet.Column("PKTABLE_SCHEM", String.class));
        cols.add(new LabKeyResultSet.Column("PKTABLE_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("PKCOLUMN_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("FKTABLE_CAT", String.class));
        cols.add(new LabKeyResultSet.Column("FKTABLE_SCHEM", String.class));
        cols.add(new LabKeyResultSet.Column("FKTABLE_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("FKCOLUMN_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("KEY_SEQ", Integer.class));
        cols.add(new LabKeyResultSet.Column("UPDATE_RULE", Short.class));
        cols.add(new LabKeyResultSet.Column("DELETE_RULE", Short.class));
        cols.add(new LabKeyResultSet.Column("FK_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("PK_NAME", String.class));
        cols.add(new LabKeyResultSet.Column("DEFERRABILITY", Short.class));
        return new LabKeyResultSet(rows, cols, this._connection);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 1 == holdability;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 6;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public List<String> getSchemaNames() throws SQLException {
        try {
            GetSchemasCommand command = new GetSchemasCommand();
            _log.info("getSchemaNames:" + this._connection.getFolderPath());
            GetSchemasResponse response = (GetSchemasResponse)command.execute(this._connection.getConnection(), this._connection.getFolderPath());
            return response.getSchemaNames();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (CommandException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        _log.log(Level.INFO, "getSchemas");
        return this.getSchemasResultSet(this.getSchemaNames());
    }

    private ResultSet getSchemasResultSet(List<String> schemaNames) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (String schemaName : schemaNames) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("TABLE_SCHEM", schemaName);
            row.put("TABLE_CATALOG", this._connection.getCatalog());
            rows.add(row);
        }
        ArrayList<LabKeyResultSet.Column> columns = new ArrayList<LabKeyResultSet.Column>();
        columns.add(new LabKeyResultSet.Column("TABLE_SCHEM", String.class));
        columns.add(new LabKeyResultSet.Column("TABLE_CATALOG", String.class));
        return new LabKeyResultSet(rows, columns, this._connection);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this._connection.setCatalog(catalog);
        if (schemaPattern == null || schemaPattern.equals("%")) {
            return this.getSchemasResultSet(this.getSchemaNames());
        }
        if (schemaPattern.contains("%") || schemaPattern.contains("_")) {
            throw new IllegalArgumentException("schemaPattern must request an exact match, but was: " + schemaPattern);
        }
        _log.log(Level.INFO, "getSchemas: " + catalog + ", " + schemaPattern);
        ArrayList<String> selectedSchemaNames = new ArrayList<String>();
        for (String schemaName : this.getSchemaNames()) {
            if (!this.matches(schemaName, schemaPattern)) continue;
            selectedSchemaNames.add(schemaName);
        }
        return this.getSchemasResultSet(selectedSchemaNames);
    }

    private boolean matches(String name, String pattern) {
        return pattern == null || pattern.equalsIgnoreCase("%") || name.equalsIgnoreCase(pattern);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return new LabKeyResultSet(Collections.<Map<String, Object>>emptyList(), Collections.<LabKeyResultSet.Column>emptyList(), this._connection);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

