/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveHashMap<V>
extends HashMap<String, V> {
    private Map<String, String> caseMap = new HashMap<String, String>();

    public CaseInsensitiveHashMap() {
    }

    public CaseInsensitiveHashMap(Map<String, V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public CaseInsensitiveHashMap(int count) {
        super(count);
    }

    @Override
    public void clear() {
        super.clear();
        this.caseMap.clear();
    }

    @Override
    public V get(Object o) {
        String key = (String)o;
        String correctCaseKey = this.caseMap.get(key);
        if (null == correctCaseKey && null != key && null != (correctCaseKey = this.caseMap.get(key.toLowerCase()))) {
            this.caseMap.put(key, correctCaseKey);
        }
        return super.get(correctCaseKey);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || key != null && super.containsKey(this.caseMap.get(((String)key).toLowerCase()));
    }

    @Override
    public V remove(Object o) {
        String key = (String)o;
        String correctCaseKey = this.caseMap.get(key);
        if (null == correctCaseKey) {
            correctCaseKey = this.caseMap.get(key == null ? null : key.toLowerCase());
        }
        V val = null == correctCaseKey ? null : (V)super.get(correctCaseKey);
        super.remove(correctCaseKey);
        ArrayList<String> casings = new ArrayList<String>();
        for (String s : this.caseMap.keySet()) {
            if (!s.equalsIgnoreCase(key)) continue;
            casings.add(s);
        }
        for (String s : casings) {
            this.caseMap.remove(s);
        }
        return val;
    }

    @Override
    public V put(String str, V o1) {
        String lcase = str == null ? null : str.toLowerCase();
        String correctCase = this.caseMap.get(lcase);
        if (null == correctCase) {
            correctCase = str;
            this.caseMap.put(lcase, correctCase);
        }
        this.caseMap.put(str, correctCase);
        return super.put(correctCase, o1);
    }

    public boolean containsKey(String key) {
        return this.containsKey((Object)key);
    }

    public V get(String key) {
        return this.get((Object)key);
    }

    public V remove(String key) {
        return this.remove((Object)key);
    }
}

