/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.IOException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.labkey.remoteapi.Command;

public class Connection {
    private static MultiThreadedHttpConnectionManager _connectionManager = null;
    private String _baseUrl;
    private String _email;
    private String _password;
    private boolean _acceptSelfSignedCerts;
    private HttpClient _client = null;
    private Integer _timeout;
    private String csrf = null;

    public Connection(String baseUrl) {
        this(baseUrl, null, null);
    }

    public Connection(String baseUrl, String email, String password) {
        this._baseUrl = baseUrl;
        this._email = email;
        this._password = password;
        this.setAcceptSelfSignedCerts(true);
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public String getEmail() {
        return this._email;
    }

    public void setEmail(String email) {
        this._email = email;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public boolean isAcceptSelfSignedCerts() {
        return this._acceptSelfSignedCerts;
    }

    public void setAcceptSelfSignedCerts(boolean acceptSelfSignedCerts) {
        this._acceptSelfSignedCerts = acceptSelfSignedCerts;
        if (this._acceptSelfSignedCerts) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        } else {
            Protocol.unregisterProtocol((String)"https");
        }
    }

    public HttpClient getHttpClient() throws URIException {
        if (null == this._client) {
            this._client = new HttpClient(this.getConnectionManager());
            if (this.getEmail() != null) {
                this._client.getState().setCredentials(new AuthScope(new URI(this.getBaseUrl(), false).getHost(), -1, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(this.getEmail(), this.getPassword()));
                this._client.getParams().setAuthenticationPreemptive(true);
            }
        } else if (this._client.getState().getCookies().length > 0) {
            this._client.getParams().setAuthenticationPreemptive(false);
        }
        return this._client;
    }

    protected synchronized void beforeExecute(HttpClient client, HttpMethod method) {
        if (null == this.csrf && method instanceof PostMethod) {
            try {
                new Command("login", "login").execute(this, "/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.csrf) {
            method.setRequestHeader("X-LABKEY-CSRF", this.csrf);
        }
    }

    protected void afterExecute(HttpClient client, HttpMethod method, int status) {
        if (null == this.csrf) {
            for (Cookie c : client.getState().getCookies()) {
                if (!"JSESSIONID".equals(c.getName())) continue;
                this.csrf = c.getValue();
            }
        }
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        HttpClient client = this.getHttpClient();
        this.beforeExecute(client, method);
        int status = client.executeMethod(method);
        this.afterExecute(client, method, status);
        return status;
    }

    protected synchronized HttpConnectionManager getConnectionManager() {
        if (null == _connectionManager) {
            _connectionManager = new MultiThreadedHttpConnectionManager();
        }
        return _connectionManager;
    }

    public void setTimeout(Integer timeout) {
        this._timeout = timeout;
    }

    public Integer getTimeout() {
        return this._timeout;
    }
}

