/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.labkey.remoteapi.ApiVersionException;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command<ResponseType extends CommandResponse> {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private String _controllerName = null;
    private String _actionName = null;
    private Map<String, Object> _parameters = null;
    private Integer _timeout = null;
    private static final int DEFAULT_TIMEOUT = 60000;
    private double _requiredVersion = 8.3;

    public Command(String controllerName, String actionName) {
        assert (null != controllerName);
        assert (null != actionName);
        this._controllerName = controllerName;
        this._actionName = actionName;
    }

    public Command(Command<ResponseType> source) {
        this._actionName = source.getActionName();
        this._controllerName = source.getControllerName();
        if (null != source.getParameters()) {
            this._parameters = new HashMap<String, Object>(source.getParameters());
        }
        this._timeout = source._timeout;
        this._requiredVersion = source.getRequiredVersion();
    }

    public String getControllerName() {
        return this._controllerName;
    }

    public String getActionName() {
        return this._actionName;
    }

    public Map<String, Object> getParameters() {
        if (null == this._parameters) {
            this._parameters = new HashMap<String, Object>();
        }
        return this._parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this._parameters = parameters;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseType execute(Connection connection, String folderPath) throws IOException, CommandException {
        Response response = this._execute(connection, folderPath);
        try {
            JSONObject json = null;
            String responseText = null;
            if (null != response.contentType && response.contentType.contains(CONTENT_TYPE_JSON)) {
                json = (JSONObject)JSONValue.parse((Reader)new BufferedReader(new InputStreamReader(response.getInputStream())));
            } else {
                responseText = response.getText();
            }
            ResponseType ResponseType = this.createResponse(responseText, response.statusCode, response.contentType, json);
            return ResponseType;
        }
        finally {
            response.close();
        }
    }

    protected Response _execute(Connection connection, String folderPath) throws CommandException, IOException {
        assert (null != this.getControllerName()) : "You must set the controller name before executing the command!";
        assert (null != this.getActionName()) : "You must set the action name before executing the command!";
        HttpMethod method = this.getHttpMethod(connection, folderPath);
        LogFactory.getLog(Command.class).info((Object)("Requesting URL: " + method.getURI().toString()));
        int status = connection.executeMethod(method);
        Header contentTypeHeader = method.getResponseHeader("Content-Type");
        String contentType = null == contentTypeHeader ? null : contentTypeHeader.getValue();
        Response response = new Response(status, contentType, method);
        if (status >= 400 && status < 600) {
            this.throwError(response);
        }
        return response;
    }

    private void throwError(Response r) throws IOException, CommandException {
        String message = null != r.getStatusText() ? r.getStatusText() : "(no status text)";
        String responseText = r.getText();
        JSONObject json = null;
        if (null != r.contentType && r.contentType.contains(CONTENT_TYPE_JSON) && responseText != null && responseText.length() > 0 && (json = (JSONObject)JSONValue.parse((String)responseText)) != null && json.containsKey((Object)"exception")) {
            message = (String)json.get((Object)"exception");
            if ("org.labkey.api.action.ApiVersionException".equals(json.get((Object)"exceptionClass"))) {
                throw new ApiVersionException(message, r.statusCode, (Map<String, Object>)json, responseText);
            }
        }
        throw new CommandException(message, r.statusCode, (Map<String, Object>)json, responseText);
    }

    protected ResponseType createResponse(String text, int status, String contentType, JSONObject json) {
        return (ResponseType)new CommandResponse(text, status, contentType, json, this.copy());
    }

    protected HttpMethod getHttpMethod(Connection connection, String folderPath) throws CommandException, URIException {
        HttpMethod method = this.createMethod();
        Integer timeout = this._timeout;
        if (timeout == null) {
            timeout = connection.getTimeout();
        }
        method.getParams().setSoTimeout(timeout == null ? 60000 : timeout);
        method.setDoAuthentication(true);
        URI uri = this.getActionUrl(connection, folderPath);
        String queryString = this.getQueryString();
        if (null != queryString) {
            uri.setRawQuery(queryString.toCharArray());
        }
        method.setURI(uri);
        return method;
    }

    protected HttpMethod createMethod() {
        return new GetMethod();
    }

    protected URI getActionUrl(Connection connection, String folderPath) throws URIException {
        String actionName;
        URI uri = new URI(connection.getBaseUrl().replace('\\', '/'), false);
        StringBuilder path = new StringBuilder(uri.getPath() == null ? "/" : uri.getPath());
        String controller = this.getControllerName();
        if (controller.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(controller);
        if (null != folderPath && folderPath.length() > 0) {
            String folderPathNormalized = folderPath.replace('\\', '/');
            if (folderPathNormalized.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
                path.append('/');
            }
            path.append(folderPathNormalized);
        }
        if ((actionName = this.getActionName()).charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(actionName);
        if (!actionName.endsWith(".api")) {
            path.append(".api");
        }
        uri.setPath(path.toString());
        return uri;
    }

    protected String getQueryString() throws CommandException {
        Map<String, Object> params = this.getParameters();
        if (this.getRequiredVersion() > 0.0) {
            params.put(CommonParameters.apiVersion.name(), this.getRequiredVersion());
        }
        StringBuilder qstring = new StringBuilder();
        URLCodec urlCodec = new URLCodec();
        try {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        this.appendParameter(qstring, urlCodec, name, o);
                    }
                    continue;
                }
                this.appendParameter(qstring, urlCodec, name, value);
            }
        }
        catch (EncoderException e) {
            throw new CommandException(e.getMessage());
        }
        return qstring.length() > 0 ? qstring.toString() : null;
    }

    private void appendParameter(StringBuilder qstring, URLCodec urlCodec, String name, Object value) throws EncoderException {
        String strValue;
        String string = strValue = null == value ? null : this.getParamValueAsString(value, name);
        if (null != strValue) {
            if (qstring.length() > 0) {
                qstring.append('&');
            }
            qstring.append(urlCodec.encode(name));
            qstring.append('=');
            qstring.append(urlCodec.encode(strValue));
        }
    }

    protected String getParamValueAsString(Object param, String name) {
        return param.toString();
    }

    public double getRequiredVersion() {
        return this._requiredVersion;
    }

    public void setRequiredVersion(double requiredVersion) {
        this._requiredVersion = requiredVersion;
    }

    public Command copy() {
        return new Command<ResponseType>(this);
    }

    protected static class Response
    implements Closeable {
        public final int statusCode;
        public final String contentType;
        private final HttpMethod method;

        Response(int statusCode, String contentType, HttpMethod method) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.method = method;
        }

        public String getStatusText() {
            return this.method.getStatusText();
        }

        public InputStream getInputStream() throws IOException {
            return this.method.getResponseBodyAsStream();
        }

        public String getText() throws IOException {
            return this.method.getResponseBodyAsString();
        }

        public void close() {
            this.method.releaseConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonParameters {
        apiVersion;

    }
}

