/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.labkey.remoteapi.Connection;

public class ClientConfig {
    private Properties _properties;
    public static final String CONFIG_ARG_PREFIX = "-config=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConfig(String[] args) throws IOException {
        File propertiesFile;
        String propertiesPath = "config.properties";
        if (args.length > 0 && args[0].startsWith(CONFIG_ARG_PREFIX)) {
            propertiesPath = args[0].substring(CONFIG_ARG_PREFIX.length());
        }
        if (!(propertiesFile = new File(propertiesPath)).exists()) {
            throw new IllegalArgumentException("Could not find config file " + propertiesPath);
        }
        this._properties = new Properties();
        FileInputStream in = new FileInputStream(propertiesFile);
        try {
            this._properties.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
        if ("true".equalsIgnoreCase(this.getProperty("debug", "false"))) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
        }
    }

    public String getProperty(String name, String defaultValue) {
        return this._properties.getProperty(name, defaultValue);
    }

    public String getProperty(String name) {
        String value = this._properties.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException("No '" + name + "' value specified in config file");
        }
        return value;
    }

    public Connection createConnection() {
        String baseServerURL = this.getProperty("baseServerURL");
        String username = this.getProperty("username");
        String password = this.getProperty("password");
        return new Connection(baseServerURL, username, password);
    }
}

