/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.util.ArrayList;
import org.labkey.remoteapi.query.Filter;
import org.labkey.remoteapi.query.SelectRowsCommand;
import org.labkey.remoteapi.query.Sort;
import org.labkey.remoteapi.sas.SASBaseSelectCommand;

public class SASSelectRowsCommand
extends SASBaseSelectCommand {
    public SASSelectRowsCommand(String schema, String query) {
        super(new SelectRowsCommand(schema, query));
    }

    private SelectRowsCommand getCommand() {
        return (SelectRowsCommand)this._command;
    }

    public void setViewName(String viewName) {
        this.getCommand().setViewName(viewName);
    }

    public void setColumns(String columns) {
        String[] array = columns.split(",");
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String name : array) {
            list.add(name.trim());
        }
        this.getCommand().setColumns(list);
    }

    public void addFilter(String columnName, String operator) {
        this.addFilter(columnName, operator, null);
    }

    public void addFilter(String columnName, String operator, String value) {
        Filter.Operator op = Filter.Operator.getOperator(operator);
        if (null == op) {
            throw new RuntimeException("Unknown operator");
        }
        if (op.isValueRequired()) {
            if (null == value) {
                throw new RuntimeException("A value is required for operator " + op.getProgrammaticName());
            }
        } else if (null != value) {
            throw new RuntimeException("A value must not be specified for operator " + op.getProgrammaticName());
        }
        this.getCommand().addFilter(columnName, value, op);
    }

    public void setSorts(String columns) {
        String[] array = columns.split(",");
        ArrayList<Sort> list = new ArrayList<Sort>(array.length);
        for (String name : array) {
            String trimmed = name.trim();
            Sort sort = trimmed.startsWith("-") ? new Sort(trimmed.substring(1), Sort.Direction.DESCENDING) : new Sort(trimmed);
            list.add(sort);
        }
        this.getCommand().setSorts(list);
    }
}

