/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.labkey.remoteapi.Connection;
import org.labkey.remoteapi.sas.NetrcFileParser;

public class SASConnection
extends Connection {
    public SASConnection(String baseUrl, String userName, String password) throws IOException, URISyntaxException {
        super(baseUrl);
        this.setEmail(userName);
        this.setPassword(password);
    }

    public SASConnection(String baseUrl) throws IOException, URISyntaxException {
        super(baseUrl);
        URI uri = new URI(baseUrl);
        this.setCredentials(uri.getHost());
    }

    private void setCredentials(String host) throws IOException {
        NetrcFileParser parser = new NetrcFileParser();
        NetrcFileParser.NetrcEntry entry = parser.getEntry(host);
        if (null != entry) {
            this.setEmail(entry.getLogin());
            this.setPassword(entry.getPassword());
        }
    }
}

