/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.sas;

import java.io.IOException;
import java.net.URISyntaxException;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.sas.SASConnection;
import org.labkey.remoteapi.sas.SASDeleteRowsCommand;
import org.labkey.remoteapi.sas.SASExecuteSqlCommand;
import org.labkey.remoteapi.sas.SASInsertRowsCommand;
import org.labkey.remoteapi.sas.SASRow;
import org.labkey.remoteapi.sas.SASSaveRowsResponse;
import org.labkey.remoteapi.sas.SASSelectRowsCommand;
import org.labkey.remoteapi.sas.SASSelectRowsResponse;

public class Main {
    public static void main(String[] args) {
        try {
            Main.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test() throws CommandException, IOException, URISyntaxException {
        SASConnection cn = new SASConnection("http://localhost:8080/labkey");
        System.out.println();
        System.out.println("All People");
        System.out.println();
        SASSelectRowsCommand command = new SASSelectRowsCommand("lists", "People");
        command.setMaxRows(0.0);
        SASSelectRowsResponse response = new SASSelectRowsResponse(cn, command, "home");
        Main.logResponse(response);
        command.addFilter("Age", "GREATER_THAN_OR_EQUAL", "12");
        response = new SASSelectRowsResponse(cn, command, "home");
        System.out.println();
        System.out.println("Old people");
        System.out.println();
        Main.logResponse(response);
        System.out.println();
        System.out.println("Specify view, columns, sort, maxRows, and offset");
        System.out.println();
        command = new SASSelectRowsCommand("lists", "People");
        command.setViewName("namesByAge");
        command.setColumns("First, Last");
        command.setSorts("Last, -First");
        command.setMaxRows(3.0);
        command.setOffset(1.0);
        response = new SASSelectRowsResponse(cn, command, "home");
        Main.logResponse(response);
        System.out.println();
        System.out.println("Test executeSql");
        System.out.println();
        SASExecuteSqlCommand execSql = new SASExecuteSqlCommand("lists", "SELECT People.Last, COUNT(People.First) AS Number, AVG(People.Height) AS AverageHeight, AVG(People.Age) AS AverageAge FROM People GROUP BY People.Last");
        response = new SASSelectRowsResponse(cn, execSql, "home");
        Main.logResponse(response);
        System.out.println();
        System.out.println("Insert new rows");
        System.out.println();
        SASInsertRowsCommand insert = new SASInsertRowsCommand("lists", "People");
        SASRow row = new SASRow();
        row.put("First", "Pebbles");
        row.put("Last", "Flintstone");
        row.put("Age", 1.0);
        row.put("Appearance", "1963-02-22");
        insert.addRow(row);
        row = new SASRow();
        row.put("First", "Bamm-Bamm");
        row.put("Last", "Rubble");
        row.put("Age", 1.0);
        row.put("Appearance", "1963-10-01");
        insert.addRow(row);
        SASSaveRowsResponse resp = new SASSaveRowsResponse(cn, insert, "home");
        System.out.println("Inserted " + resp.getRowsAffected() + " rows.");
        System.out.println();
        System.out.println("Display new rows");
        System.out.println();
        command = new SASSelectRowsCommand("lists", "People");
        response = new SASSelectRowsResponse(cn, command, "home");
        Main.logResponse(response);
        System.out.println();
        System.out.println("Delete new rows");
        System.out.println();
        command.setColumns("Key");
        command.addFilter("Age", "LESS_THAN_OR_EQUAL", "1");
        response = new SASSelectRowsResponse(cn, command, "home");
        SASDeleteRowsCommand delete = new SASDeleteRowsCommand("lists", "People");
        while (response.getRow()) {
            row = new SASRow();
            row.put("Key", response.getNumeric("Key"));
            delete.addRow(row);
        }
        resp = new SASSaveRowsResponse(cn, delete, "home");
        System.out.println("Deleted " + resp.getRowsAffected() + " rows.");
    }

    private static void logResponse(SASSelectRowsResponse response) {
        String missingCode = response.getMissingValuesCode();
        System.out.println(missingCode);
        int columnCount = response.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (response.isHidden(i)) continue;
            String column = response.getColumnName(i);
            String type = response.getType(column);
            System.out.println(column + " (" + response.getLabel(i) + ")" + ": " + type + ("STRING".equals(type) ? " " + response.getScale(i) : ""));
        }
        while (response.getRow()) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < columnCount; ++i) {
                String qc;
                if (response.isHidden(i)) continue;
                String column = response.getColumnName(i);
                String type = response.getType(column);
                if ("STRING".equals(type)) {
                    line.append(response.getCharacter(column));
                } else if (response.isNull(column)) {
                    line.append("null");
                } else if ("DATE".equals(type)) {
                    line.append(response.getDate(column));
                } else if ("BOOLEAN".equals(type)) {
                    line.append(response.getBoolean(column));
                } else {
                    line.append(response.getNumeric(column));
                }
                if (response.allowsMissingValues(column) && null != (qc = response.getMissingValue(column))) {
                    line.append(" (").append(qc).append(")");
                }
                line.append(" ");
            }
            System.out.println(line);
        }
    }
}

