/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.query.BaseQueryCommand;
import org.labkey.remoteapi.query.BaseSelect;
import org.labkey.remoteapi.query.Filter;
import org.labkey.remoteapi.query.SelectRowsResponse;
import org.labkey.remoteapi.query.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRowsCommand
extends BaseQueryCommand<SelectRowsResponse>
implements BaseSelect {
    private String _schemaName;
    private String _queryName;
    private String _viewName;
    private List<String> _columns = new ArrayList<String>();

    public SelectRowsCommand(String schemaName, String queryName) {
        super("query", "selectRows");
        assert (null != schemaName);
        assert (null != queryName);
        this._schemaName = schemaName;
        this._queryName = queryName;
    }

    public SelectRowsCommand(SelectRowsCommand source) {
        super(source);
        this._schemaName = source._schemaName;
        this._queryName = source._queryName;
        this._viewName = source._viewName;
        this._columns.addAll(source._columns);
    }

    public void setExtendedFormat(boolean extendedFormat) {
        this.setRequiredVersion(extendedFormat ? 9.1 : 8.3);
    }

    public boolean isExtendedFormat() {
        return this.getRequiredVersion() == 9.1;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public String getQueryName() {
        return this._queryName;
    }

    public void setQueryName(String queryName) {
        this._queryName = queryName;
    }

    public String getViewName() {
        return this._viewName;
    }

    public void setViewName(String viewName) {
        this._viewName = viewName;
    }

    public List<String> getColumns() {
        return this._columns;
    }

    public void setColumns(List<String> columns) {
        this._columns = columns;
    }

    @Override
    protected SelectRowsResponse createResponse(String text, int status, String contentType, JSONObject json) {
        return new SelectRowsResponse(text, status, contentType, json, this.copy());
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("schemaName", this.getSchemaName());
        params.put("query.queryName", this.getQueryName());
        if (null != this.getViewName()) {
            params.put("query.viewName", this.getViewName());
        }
        if (null != this.getColumns() && this.getColumns().size() > 0) {
            StringBuilder collist = new StringBuilder();
            String sep = "";
            for (String col : this.getColumns()) {
                collist.append(sep);
                collist.append(col);
                sep = ",";
            }
            params.put("query.columns", collist);
        }
        if (this.getMaxRows() >= 0) {
            params.put("query.maxRows", this.getMaxRows());
        } else {
            params.put("query.showRows", "all");
        }
        if (this.getOffset() > 0) {
            params.put("query.offset", this.getOffset());
        }
        if (null != this.getSorts() && this.getSorts().size() > 0) {
            params.put("query.sort", Sort.getSortQueryStringParam(this.getSorts()));
        }
        if (null != this.getFilters()) {
            for (Filter filter : this.getFilters()) {
                params.put("query." + filter.getQueryStringParamName(), filter.getQueryStringParamValue());
            }
        }
        if (this.getContainerFilter() != null) {
            params.put("containerFilter", this.getContainerFilter().name());
        }
        return params;
    }

    @Override
    public SelectRowsCommand copy() {
        return new SelectRowsCommand(this);
    }
}

