/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.collections.CaseInsensitiveHashMap;
import org.labkey.remoteapi.query.DateParser;
import org.labkey.remoteapi.query.SelectRowsResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowsResponse
extends CommandResponse {
    protected RowsResponse(String text, int statusCode, String contentType, JSONObject json, Command sourceCommand) {
        super(text, statusCode, contentType, json, sourceCommand);
        this.fixupParsedData();
        this.caseInsensitizeRowMaps();
    }

    public List<Map<String, Object>> getRows() {
        return (List)this.getProperty("rows");
    }

    protected void fixupParsedData() {
        if (null == this.getParsedData()) {
            return;
        }
        ArrayList<String> dateFields = new ArrayList<String>();
        ArrayList<String> intFields = new ArrayList<String>();
        ArrayList<String> floatFields = new ArrayList<String>();
        List fields = (List)this.getProperty("metaData.fields");
        if (null == fields) {
            return;
        }
        for (Map field : fields) {
            String type = (String)field.get("type");
            if ("date".equalsIgnoreCase(type)) {
                dateFields.add((String)field.get("name"));
                continue;
            }
            if ("float".equalsIgnoreCase(type)) {
                floatFields.add((String)field.get("name"));
                continue;
            }
            if (!"int".equalsIgnoreCase(type)) continue;
            intFields.add((String)field.get("name"));
        }
        if (dateFields.size() == 0 && floatFields.size() == 0 && intFields.size() == 0) {
            return;
        }
        List<Map<String, Object>> rows = this.getRows();
        if (null == rows || rows.size() == 0) {
            return;
        }
        DateParser dateFormat = new DateParser();
        boolean expandedFormat = this.getRequiredVersion() == 9.1;
        for (Map<String, Object> row : rows) {
            Number number;
            Object value;
            for (String field : dateFields) {
                Object dateString = expandedFormat ? ((JSONObject)row.get(field)).get((Object)"value") : row.get(field);
                if (null == dateString || !(dateString instanceof String)) continue;
                try {
                    Date date = dateFormat.parse((String)dateString);
                    if (null == date) continue;
                    if (expandedFormat) {
                        ((JSONObject)row.get(field)).put((Object)"value", (Object)date);
                        continue;
                    }
                    row.put(field, date);
                }
                catch (ParseException e) {
                    LogFactory.getLog(SelectRowsResponse.class).warn((Object)("Failed to parse date '" + dateString + "': " + e));
                }
            }
            for (String field : floatFields) {
                value = expandedFormat ? ((JSONObject)row.get(field)).get((Object)"value") : row.get(field);
                if (!(value instanceof Number)) continue;
                number = new Double(((Number)value).doubleValue());
                if (expandedFormat) {
                    ((JSONObject)row.get(field)).put((Object)"value", (Object)number);
                    continue;
                }
                row.put(field, number);
            }
            for (String field : intFields) {
                value = expandedFormat ? ((JSONObject)row.get(field)).get((Object)"value") : row.get(field);
                if (!(value instanceof Number)) continue;
                number = new Integer(((Number)value).intValue());
                if (expandedFormat) {
                    ((JSONObject)row.get(field)).put((Object)"value", (Object)number);
                    continue;
                }
                row.put(field, number);
            }
        }
    }

    protected void caseInsensitizeRowMaps() {
        ArrayList<CaseInsensitiveHashMap<Object>> ciRows = new ArrayList<CaseInsensitiveHashMap<Object>>();
        for (Map<String, Object> row : this.getRows()) {
            ciRows.add(new CaseInsensitiveHashMap<Object>(row));
        }
        this.getParsedData().put("rows", ciRows);
    }
}

