/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.util.HashMap;
import java.util.Map;

public class Filter {
    private String _columnName;
    private Operator _operator = Operator.EQUAL;
    private Object _value;

    public Filter(String columnName, Object value) {
        this._columnName = columnName;
        this._value = value;
    }

    public Filter(String columnName, Object value, Operator operator) {
        this._columnName = columnName;
        this._value = value;
        this._operator = operator;
    }

    public Filter(Filter source) {
        this._columnName = source._columnName;
        this._operator = source._operator;
        this._value = source._value;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public void setColumnName(String columnName) {
        this._columnName = columnName;
    }

    public Operator getOperator() {
        return this._operator;
    }

    public void setOperator(Operator operator) {
        this._operator = operator;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getQueryStringParamName() {
        return null == this.getColumnName() || null == this.getOperator() ? "" : this.getColumnName() + "~" + this.getOperator().getName();
    }

    public String getQueryStringParamValue() {
        return null == this.getValue() ? "" : this.getValue().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQUAL("eq", "Equals", "EQUAL", true),
        NEQ("neq", "Does Not Equal", "NOT_EQUAL", true),
        NEQ_OR_NULL("neqornull", "Does Not Equal", "NOT_EQUAL_OR_MISSING", true),
        DATE_EQUAL("dateeq", "Equals", "DATE_EQUAL", true),
        DATE_NOT_EQUAL("dateneq", "Does Not Equal", "DATE_NOT_EQUAL", true),
        ISBLANK("isblank", "Is Blank", "MISSING", false),
        NON_BLANK("isnonblank", "Is Not Blank", "NOT_MISSING", false),
        GT("gt", "Is Greater Than", "GREATER_THAN", true),
        GTE("gte", "Is Greater Than or Equal To", "GREATER_THAN_OR_EQUAL", true),
        LT("lt", "Is Less Than", "LESS_THAN", true),
        LTE("lte", "Is Less Than or Equal To", "LESS_THAN_OR_EQUAL", true),
        CONTAINS("contains", "Contains", "CONTAINS", true),
        DOES_NOT_CONTAIN("doesnotcontain", "Does Not Contain", "DOES_NOT_CONTAIN", true),
        STARTS_WITH("startswith", "Starts With", "STARTS_WITH", true),
        DOES_NOT_START_WITH("doesnotstartwith", "Does Not Start With", "DOES_NOT_START_WITH", true),
        IN("in", "Equals One Of", "IN", true),
        NOT_IN("notin", "Does Not Equal Any Of (e.g. 'a;b;c')", "NOT_IN", true),
        CONTAINS_ONE_OF("containsoneof", "Contains One Of (e.g. 'a;b;c')", "CONTAINS_ONE_OF", true),
        CONTAINS_NONE_OF("containsnoneof", "Does Not Contain Any Of (e.g. 'a;b;c')", "CONTAINS_NONE_OF", true);

        private static final Map<String, Operator> _programmaticNameToOperator;
        private String _name;
        private String _caption;
        private String _programmaticName;
        private boolean _valueRequired;

        private Operator(String name, String caption, String programmaticName, boolean valueRequired) {
            this._name = name;
            this._caption = caption;
            this._programmaticName = programmaticName;
            this._valueRequired = valueRequired;
        }

        public String getName() {
            return this._name;
        }

        public String getCaption() {
            return this._caption;
        }

        public boolean isValueRequired() {
            return this._valueRequired;
        }

        public String getProgrammaticName() {
            return this._programmaticName;
        }

        public static Operator getOperator(String programmaticName) {
            return _programmaticNameToOperator.get(programmaticName);
        }

        static {
            _programmaticNameToOperator = new HashMap<String, Operator>(Operator.values().length);
            for (Operator o : Operator.values()) {
                _programmaticNameToOperator.put(o.getProgrammaticName(), o);
            }
        }
    }
}

