/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.query.ContainerFilter;
import org.labkey.remoteapi.query.Filter;
import org.labkey.remoteapi.query.Sort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseQueryCommand<ResponseType extends CommandResponse>
extends Command<ResponseType> {
    protected int _maxRows = -1;
    protected int _offset = 0;
    protected List<Sort> _sorts = new ArrayList<Sort>();
    protected List<Filter> _filters = new ArrayList<Filter>();
    protected ContainerFilter _containerFilter;
    private Map<String, String> _queryParameters = new HashMap<String, String>();

    public BaseQueryCommand(BaseQueryCommand<ResponseType> source) {
        super(source);
        this._containerFilter = source._containerFilter;
        this._offset = source._offset;
        this._maxRows = source._maxRows;
        for (Sort sort : source._sorts) {
            this._sorts.add(new Sort(sort));
        }
        for (Filter filter : source._filters) {
            this._filters.add(new Filter(filter));
        }
    }

    public BaseQueryCommand(String controllerName, String actionName) {
        super(controllerName, actionName);
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public List<Sort> getSorts() {
        return this._sorts;
    }

    public void setSorts(List<Sort> sorts) {
        this._sorts = sorts;
    }

    public void addSort(Sort sort) {
        if (this._sorts == null) {
            this._sorts = new ArrayList<Sort>();
        }
        this._sorts.add(sort);
    }

    public void addSort(String columnName, Sort.Direction direction) {
        this.addSort(new Sort(columnName, direction));
    }

    public List<Filter> getFilters() {
        return this._filters;
    }

    public void setFilters(List<Filter> filters) {
        this._filters = filters;
    }

    public void addFilter(Filter filter) {
        this.getFilters().add(filter);
    }

    public void addFilter(String columnName, Object value, Filter.Operator operator) {
        this.addFilter(new Filter(columnName, value, operator));
    }

    public ContainerFilter getContainerFilter() {
        return this._containerFilter;
    }

    public void setContainerFilter(ContainerFilter containerFilter) {
        this._containerFilter = containerFilter;
    }

    public Map<String, String> getQueryParameters() {
        return this._queryParameters;
    }

    public void setQueryParameters(Map<String, String> parameters) {
        this._queryParameters = parameters;
    }

    @Override
    public Map<String, Object> getParameters() {
        Map<String, Object> params = super.getParameters();
        if (this.getOffset() > 0) {
            params.put("offset", this.getOffset());
        }
        if (this.getMaxRows() >= 0) {
            params.put("maxRows", this.getMaxRows());
        }
        if (null != this.getSorts() && this.getSorts().size() > 0) {
            params.put("query.sort", Sort.getSortQueryStringParam(this.getSorts()));
        }
        if (null != this.getFilters()) {
            for (Filter filter : this.getFilters()) {
                params.put("query." + filter.getQueryStringParamName(), filter.getQueryStringParamValue());
            }
        }
        if (this.getContainerFilter() != null) {
            params.put("containerFilter", this.getContainerFilter().name());
        }
        for (Map.Entry entry : this.getQueryParameters().entrySet()) {
            params.put("query.param." + (String)entry.getKey(), entry.getValue());
        }
        return params;
    }
}

