/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.ms2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.Command;
import org.labkey.remoteapi.ms2.StartSearchResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartSearchCommand
extends Command<StartSearchResponse> {
    private String _protocol;
    private String _path;
    private List<String> _files;
    private final SearchEngine _searchEngine;

    public StartSearchCommand(SearchEngine searchEngine, String protocol, String path, List<String> files) {
        super("ms2-pipeline", "search" + searchEngine.name());
        this._searchEngine = searchEngine;
        this.setProtocol(protocol);
        this.setPath(path);
        this.setFiles(files);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public List<String> getFiles() {
        return this._files;
    }

    public void setFiles(List<String> files) {
        this._files = files;
    }

    @Override
    protected HttpMethod createMethod() {
        return new PostMethod();
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("path", this._path);
        result.put("file", this._files);
        result.put("protocol", this._protocol);
        result.put("runSearch", true);
        return result;
    }

    @Override
    protected StartSearchResponse createResponse(String text, int status, String contentType, JSONObject json) {
        if (text.startsWith("ERROR=")) {
            throw new IllegalArgumentException(text.substring("ERROR=".length()));
        }
        return new StartSearchResponse(text, status, contentType, json, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchEngine {
        XTandem,
        Sequest,
        Mascot;

    }
}

