/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi.assay;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.json.simple.JSONObject;
import org.labkey.remoteapi.PostCommand;
import org.labkey.remoteapi.assay.ImportRunResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportRunCommand
extends PostCommand<ImportRunResponse> {
    private boolean _useJson = false;
    private int _batchId;
    private int _assayId;
    private String _name;
    private String _comment;
    private Map<String, Object> _properties;
    private Map<String, Object> _batchProperties;
    private File _file;

    public ImportRunCommand(int assayId, File file) {
        super("assay", "importRun");
        this._assayId = assayId;
        this._file = file;
    }

    public void setUseJson(boolean useJson) {
        this._useJson = useJson;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setProperties(Map<String, Object> properties) {
        this._properties = properties;
    }

    public void setBatchId(int batchId) {
        this._batchId = batchId;
    }

    public void setBatchProperties(Map<String, Object> batchProperties) {
        this._batchProperties = batchProperties;
    }

    @Override
    public ImportRunCommand copy() {
        ImportRunCommand cmd = new ImportRunCommand(this._assayId, this._file);
        cmd._useJson = this._useJson;
        cmd._name = this._name;
        cmd._comment = this._comment;
        cmd._properties = this._properties;
        cmd._batchId = this._batchId;
        cmd._batchProperties = this._batchProperties;
        return cmd;
    }

    @Override
    protected ImportRunResponse createResponse(String text, int status, String contentType, JSONObject json) {
        return new ImportRunResponse(text, status, contentType, json, this);
    }

    @Override
    protected HttpMethod createMethod() {
        MultipartPostMethod method = new MultipartPostMethod();
        if (this._assayId == 0) {
            throw new IllegalArgumentException("assay id required");
        }
        if (this._file == null) {
            throw new IllegalArgumentException("file required");
        }
        if (this._useJson) {
            JSONObject json = new JSONObject();
            json.put((Object)"apiVersion", (Object)this.getRequiredVersion());
            json.put((Object)"assayId", (Object)this._assayId);
            if (this._batchId > 0) {
                json.put((Object)"batchId", (Object)this._batchId);
            }
            if (this._name != null) {
                json.put((Object)"name", (Object)this._name);
            }
            if (this._comment != null) {
                json.put((Object)"comment", (Object)this._comment);
            }
            if (this._properties != null) {
                json.put((Object)"properties", this._properties);
            }
            if (this._batchProperties != null) {
                json.put((Object)"batchProperties", this._batchProperties);
            }
            StringPart jsonPart = new StringPart("json", json.toJSONString(), "UTF-8");
            jsonPart.setContentType("application/json");
            method.addPart((Part)jsonPart);
        } else {
            method.addPart((Part)new StringPart("assayId", String.valueOf(this._assayId)));
            if (this._batchId > 0) {
                method.addPart((Part)new StringPart("batchId", String.valueOf(this._batchId)));
            }
            if (this._name != null) {
                method.addPart((Part)new StringPart("name", String.valueOf(this._name)));
            }
            if (this._comment != null) {
                method.addPart((Part)new StringPart("comment", String.valueOf(this._comment)));
            }
            if (this._properties != null) {
                for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
                    method.addPart((Part)new StringPart("properties[" + entry.getKey() + "]", String.valueOf(entry.getValue())));
                }
            }
            if (this._batchProperties != null) {
                for (Map.Entry<String, Object> entry : this._batchProperties.entrySet()) {
                    method.addPart((Part)new StringPart("batchProperties[" + entry.getKey() + "]", String.valueOf(entry.getValue())));
                }
            }
        }
        try {
            FilePart filePart = new FilePart("file", this._file, "application/octet-stream", "UTF-8");
            method.addPart((Part)filePart);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return method;
    }
}

