/*
 * Decompiled with CFR 0.152.
 */
package org.labkey.remoteapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.labkey.remoteapi.ApiVersionException;
import org.labkey.remoteapi.CommandException;
import org.labkey.remoteapi.CommandResponse;
import org.labkey.remoteapi.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command<ResponseType extends CommandResponse> {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private String _controllerName = null;
    private String _actionName = null;
    private Map<String, Object> _parameters = null;
    private int _timeout = 60000;
    private double _requiredVersion = 8.3;

    public Command(String controllerName, String actionName) {
        assert (null != controllerName);
        assert (null != actionName);
        this._controllerName = controllerName;
        this._actionName = actionName;
    }

    public Command(Command<ResponseType> source) {
        this._actionName = source.getActionName();
        this._controllerName = source.getControllerName();
        if (null != source.getParameters()) {
            this._parameters = new HashMap<String, Object>(source.getParameters());
        }
        this._timeout = source.getTimeout();
        this._requiredVersion = source.getRequiredVersion();
    }

    public String getControllerName() {
        return this._controllerName;
    }

    public String getActionName() {
        return this._actionName;
    }

    public Map<String, Object> getParameters() {
        if (null == this._parameters) {
            this._parameters = new HashMap<String, Object>();
        }
        return this._parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this._parameters = parameters;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResponseType execute(Connection connection, String folderPath) throws IOException, CommandException {
        assert (null != this.getControllerName()) : "You must set the controller name before executing the command!";
        assert (null != this.getActionName()) : "You must set the action name before executing the command!";
        HttpMethod method = this.getHttpMethod(connection, folderPath);
        int status = 0;
        String responseText = null;
        String contentType = null;
        JSONObject json = null;
        try {
            LogFactory.getLog(Command.class).info((Object)("Requesting URL: " + method.getURI().toString()));
            status = connection.executeMethod(method);
            Header contentTypeHeader = method.getResponseHeader("Content-Type");
            String string = contentType = null == contentTypeHeader ? null : contentTypeHeader.getValue();
            if (null != contentType && contentType.contains(CONTENT_TYPE_JSON)) {
                InputStream stream = method.getResponseBodyAsStream();
                json = (JSONObject)JSONValue.parse((Reader)new BufferedReader(new InputStreamReader(stream)));
            } else {
                responseText = method.getResponseBodyAsString();
            }
        }
        finally {
            method.releaseConnection();
        }
        if (status >= 400 && status < 600) {
            String message;
            String string = message = null != method.getStatusText() ? method.getStatusText() : "(no status text)";
            if (null != contentType && contentType.contains(CONTENT_TYPE_JSON) && null != json && json.containsKey((Object)"exception")) {
                message = (String)json.get((Object)"exception");
                if ("org.labkey.api.action.ApiVersionException".equals(json.get((Object)"exceptionClass"))) {
                    throw new ApiVersionException(message, status, (Map<String, Object>)json, responseText);
                }
            }
            throw new CommandException(message, status, (Map<String, Object>)json, responseText);
        }
        return this.createResponse(responseText, status, contentType, json);
    }

    protected ResponseType createResponse(String text, int status, String contentType, JSONObject json) {
        return (ResponseType)new CommandResponse(text, status, contentType, json, this.copy());
    }

    protected HttpMethod getHttpMethod(Connection connection, String folderPath) throws CommandException, URIException {
        HttpMethod method = this.createMethod();
        method.getParams().setSoTimeout(this.getTimeout());
        method.setDoAuthentication(true);
        URI uri = this.getActionUrl(connection, folderPath);
        String queryString = this.getQueryString();
        if (null != queryString) {
            uri.setRawQuery(queryString.toCharArray());
        }
        method.setURI(uri);
        return method;
    }

    protected HttpMethod createMethod() {
        return new GetMethod();
    }

    protected URI getActionUrl(Connection connection, String folderPath) throws URIException {
        String actionName;
        URI uri = new URI(connection.getBaseUrl().replace('\\', '/'), false);
        StringBuilder path = new StringBuilder(uri.getPath() == null ? "/" : uri.getPath());
        String controller = this.getControllerName();
        if (controller.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(controller);
        if (null != folderPath && folderPath.length() > 0) {
            String folderPathNormalized = folderPath.replace('\\', '/');
            if (folderPathNormalized.charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
                path.append('/');
            }
            path.append(folderPathNormalized);
        }
        if ((actionName = this.getActionName()).charAt(0) != '/' && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(actionName);
        if (!actionName.endsWith(".api")) {
            path.append(".api");
        }
        uri.setPath(path.toString());
        return uri;
    }

    protected String getQueryString() throws CommandException {
        Map<String, Object> params = this.getParameters();
        if (this.getRequiredVersion() > 0.0) {
            params.put(CommonParameters.apiVersion.name(), this.getRequiredVersion());
        }
        StringBuilder qstring = new StringBuilder();
        URLCodec urlCodec = new URLCodec();
        try {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        this.appendParameter(qstring, urlCodec, name, o);
                    }
                    continue;
                }
                this.appendParameter(qstring, urlCodec, name, value);
            }
        }
        catch (EncoderException e) {
            throw new CommandException(e.getMessage());
        }
        return qstring.length() > 0 ? qstring.toString() : null;
    }

    private void appendParameter(StringBuilder qstring, URLCodec urlCodec, String name, Object value) throws EncoderException {
        String strValue;
        String string = strValue = null == value ? null : this.getParamValueAsString(value, name);
        if (null != strValue) {
            if (qstring.length() > 0) {
                qstring.append('&');
            }
            qstring.append(urlCodec.encode(name));
            qstring.append('=');
            qstring.append(urlCodec.encode(strValue));
        }
    }

    protected String getParamValueAsString(Object param, String name) {
        return param.toString();
    }

    public double getRequiredVersion() {
        return this._requiredVersion;
    }

    public void setRequiredVersion(double requiredVersion) {
        this._requiredVersion = requiredVersion;
    }

    public Command copy() {
        return new Command<ResponseType>(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonParameters {
        apiVersion;

    }
}

